/* ss_rrobin.c
   */

#include "general.h"
#include "lock.h"
#include "queue.h"
#include "results.h"
#include "init.h"
#include "internal.h"
#include "arch_init.h"

extern void child_exit ARGS((int));

extern private locked_queue_t local_thread_queue[MAX_PROC];
extern private struct sched *local_scheduler[MAX_PROC];

sched_info_t
rr_sched_global_init(node)
int node;
{
	return(allocate_and_init_scb(node, 1, config.threads_per_proc));
}

void *
rr_sched_vproc_init(node)
int node;
{
        local_thread_queue[node] = local_scheduler[node]->lqueue[0];
        ualarm(1000, 0);
}
 
void *
rr_sched_empty_readyq()
{
    int proc = virtual_processor();
    return((void *)Fifo_emptyq(local_thread_queue[proc]));
}

void *
rr_sched_get_thread(node)
int node;
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   next_thread = (cthread_t) Fifo_dequeue(local_thread_queue[proc]);
   return((void *)next_thread);
}

void *
rr_sched_put_thread(node,thread)
int node;
cthread_t thread;
{
   if(node != virtual_processor()) {
       Fifo_enqueue((processor[node].scheduler)->lqueue[0], thread);
   } else  {
       Fifo_enqueue(local_thread_queue[node], thread);
   }
}

void *
rr_schedule()
{
      while (1);
}

void
rr_timer_handler()
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   if (((local_scheduler[proc]->sched_empty_readyq)()) && 
       (processor[proc].terminate != TERMINATE)) {
       ualarm(1000, 0);
       return;
   }
   next_thread = (cthread_t)(local_scheduler[proc]->sched_get_thread)(proc);
   if (next_thread == 0 && processor[proc].terminate == TERMINATE) {
     child_exit(0);
   }
   if (current_thread_array[proc] != 0){
       swap_context_with_func(rr_schedule_next, next_thread);
   } else {
       ualarm(1000, 0);
       sched_dispatch(next_thread);
   }
}

static void
rr_schedule_next(next_thread)
cthread_t next_thread;
{
    int proc = virtual_processor();
    cthread_t current_thread = current_thread_array[virtual_processor()];

    (local_scheduler[proc]->sched_put_thread) (proc, current_thread);
    ualarm(1000, 0);
    sched_dispatch(next_thread);
}
