#include "general.h"
#include "sched_utils.h"
#include "internal.h"
#include "hwlib.h"
#include "arch_init.h"

extern private struct sched		*local_scheduler[MAX_PROC];
extern private locked_queue_t	local_thread_queue[MAX_PROC];
extern shared struct local_info	*processor;
extern cthread_t current_thread_array[MAX_PROC];	/* The currently executing thread*/
extern void child_exit();

sched_info_t
  monitor_global_init(node)
int node;
{
        return(allocate_and_init_scb(node, 1,3));
}

void
monitor_vproc_init(node)
int node;
{
        local_thread_queue[node] = local_scheduler[node]->lqueue[0];
}

void *
monitor_empty_readyq()
{
    int proc = virtual_processor();
    return((void *)Fifo_emptyq(local_thread_queue[proc]));
}

void *
monitor_get_thread(node)
int node;
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   next_thread = (cthread_t) Fifo_dequeue(local_thread_queue[proc]);
   return((void *)next_thread);
}

void
monitor_put_thread(node,thread)
int node;
cthread_t thread;
{
    if (node != virtual_processor()) {
	locked_enqueue((processor[node].scheduler)->lqueue[0],
		       (queue_item_t) thread);
    } else {
       cthread_spin_lock(&local_thread_queue[node]->lqlock);
       enqueue(&local_thread_queue[node]->lcqueue, (queue_item_t) thread);
       cthread_spin_unlock(&local_thread_queue[node]->lqlock);
   }
}

void
monitor_schedule()
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   DBG("Monitor schedule\n");
   /* do periodic thing */
   if (cthread_in_schedule_function[proc] != 0) {
       (cthread_in_schedule_function[proc])(proc);
   }
   
   /* the following loop avoids a spin lock on an empty queue */
   while(((local_scheduler[proc]->sched_empty_readyq)()) &&
	 (processor[proc].terminate != TERMINATE)) {
       DBG1("Monitor terminate is %d\n", processor[proc].terminate);
       if (cthread_in_schedule_function[proc] != 0) {
	   (cthread_in_schedule_function[proc])(proc);
	   
       }
   }
   next_thread = (cthread_t)(local_scheduler[proc]->sched_get_thread)(proc);
   if ((next_thread == 0) &&
       (processor[proc].terminate == TERMINATE)) {
       DBG("Monitor scheduler forcing exit\n");
       child_exit(0);
   }
   current_thread_array[proc] = next_thread;
   DISPATCH(next_thread);
}
