/*
 * ss_cthreads.c
 */
#include "general.h"
#include "sched_utils.h"
#include "internal.h"
#include "init.h"
#include "hwlib.h"
#include "arch_init.h"
#include "sched_io.h"


extern struct configuration config;
extern private struct sched		*local_scheduler[MAX_PROC];
extern private locked_queue_t	local_thread_queue[MAX_PROC];
extern shared struct local_info	*processor;

/* presumably machine and OS specific and defined elsewhere */
extern void child_exit();

void
empty_runq_function()
{
    sched_relinquish_processor();
}


sched_info_t
  cth_sched_global_init(node)
int node;
{
	return(allocate_and_init_scb(node, 1, config.threads_per_proc));
}

void
cth_sched_vproc_init(node)
int node;
{
        local_thread_queue[node] = local_scheduler[node]->lqueue[0];
}
 
void
cth_sched_thread_init(t)
cthread_t t;
{
}

void *
cth_sched_empty_readyq()
{
    int proc = virtual_processor();
    return((void *)(local_thread_queue[proc]->lcqueue.first == 0));
}

void *
cth_sched_get_thread(node)
int node;
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   cthread_spin_lock(&local_thread_queue[proc]->lqlock);
   next_thread = (cthread_t) dequeue(&local_thread_queue[proc]->lcqueue);
   cthread_spin_unlock(&local_thread_queue[proc]->lqlock);
   return((void *)next_thread);
}

void
cth_sched_put_thread(node,thread)
int node;
cthread_t thread;
{
   if(node != virtual_processor()) {
       locked_enqueue((processor[node].scheduler)->lqueue[0], 
		      (queue_item_t) thread);
   } else {
       cthread_spin_lock(&local_thread_queue[node]->lqlock);
       enqueue(&local_thread_queue[node]->lcqueue, (queue_item_t) thread);
       cthread_spin_unlock(&local_thread_queue[node]->lqlock);
   }
}

void
cth_schedule()
{
   cthread_t    next_thread;
   int proc = virtual_processor();

   check_pending_io();

   /* do periodic thing */
   if (cthread_in_schedule_function[proc] != 0) {
       (cthread_in_schedule_function[proc])(proc);
   }

   /* the following loop avoids a spin lock on an empty queue */

   do {
      while(((local_scheduler[proc]->sched_empty_readyq)()) && 
	     (processor[proc].terminate != TERMINATE)) {
   	   empty_runq_function();
           /* do periodic thing */
	   if (cthread_in_schedule_function[proc] != 0) {
       	  (cthread_in_schedule_function[proc])(proc);
	}
      }
      next_thread = (cthread_t)(local_scheduler[proc]->sched_get_thread)(proc);
    
      if (next_thread == 0) {
          /* for sure processor[proc].terminate == TERMINATE */
            if(  local_scheduler[proc]->pending_io_count == 0) {
                  	child_exit(0);
		      }
	      }
        } while (next_thread == 0);

   sched_dispatch(next_thread);
}
