#include <sys/types.h>
#include <stdio.h>

#include "assert.h"
#include "general.h"
#include "internal.h"
#include "sparc_init.h"
#include "hwlib.h"

/* defined in threads.c */
void start_thread ARGS((int (*func)(), any_t arg));
void start_threadV ARGS((int	(* func)(), int	n, any_t arg));
extern cthread_t current_thread_array[MAX_PROC];

static void
exchange(lock, val, out)
u_int *lock;
u_int val;
u_int *out;
{
#ifdef __GNUC__
    register long tmp = val;
    asm("swap %2, %0;st %0, %3" 
	: "=g" (tmp)
	: "0" (tmp), "g" (*lock), "g"(*out));
#else
    asm("swap [%i0], %i1");
    asm ("st %i1, [%i2]");
#endif
}

int TRY_TO_LOCK(l)
LOCK *l;
{
        u_int out = 0;
        exchange(l, 0x00ff, &out);
        return out;
}

#if defined(__svr4__) || defined(__SVR4)
/*
**  THIS IS CODE FOR SOLARIS!!
*/
#include <unistd.h>
#include <ucontext.h>
#include "init.h"

int getpagesize()
{
    return sysconf(_SC_PAGESIZE);
}

void
fix_jbuf(thread, func, arg)
cthread_t thread;
any_t (*func)();
long *arg;
{
    getcontext(thread->jbuf);

    /* round the stack value down to something divisible by 8 
       and substitute it in for the sp in the context */
    thread->jbuf->uc_stack.ss_sp = (char*)((long)thread->usable_stack_base & ~0xf);
    thread->jbuf->uc_stack.ss_sp = (char*)(thread->jbuf->uc_stack.ss_sp) - 
	CONTEXT_FUDGE_VALUE;
    thread->jbuf->uc_stack.ss_size = config.stack_size;
    thread->jbuf->uc_stack.ss_flags = 0;
    DBG1("stack pointer in fix_jbuf is %lx\n", 
	 (long)thread->jbuf->uc_stack.ss_sp);
    makecontext(thread->jbuf, (void(*)()) start_thread, 3, func, arg);
    DBG1("stack pointer after makecontext is %lx\n", 
	 (long)thread->jbuf->uc_stack.ss_sp);
}

void
DISPATCH(thread)
cthread_t thread;
{
    if (!(thread)->already_started) { 
	(thread)->already_started = 1;
	fix_jbuf(thread, thread->func, thread->arg);
    }
    setcontext((thread)->jbuf);
}

void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];
    ucontext_t tmp_context;
    getcontext(&tmp_context);
    DBG2("swap context context %lx, sp = %lx\n", (long)&tmp_context, 
	 (long)tmp_context.uc_stack.ss_sp);

    /*
    ** oddly, the sp in the context seems to be *NOT* the one we're 
    ** currently executing on.  Why is this?  I don't know.  Substitute
    ** a better value (128 bytes past the end of the context local variable)
    */
    tmp_context.uc_stack.ss_sp = ((char *)&tmp_context) - 
      sizeof(tmp_context) - 0x100;
    makecontext(&tmp_context, func, 2, arg);
    DBG2("swap context2 %lx, sp = %lx\n", (long)&tmp_context, 
	 (long)tmp_context.uc_stack.ss_sp);
    DBG3("[%d]swap context, swapout thread %lx, func %lx\n", 
	 virtual_processor(), (long) current_thread, (long) func);
    if (swapcontext(current_thread->jbuf, &tmp_context) != 0)
      perror("swapcontext");
}

void *
get_sp_from_context(context_ptr)
cthread_context context_ptr;
{
    return(context_ptr->uc_stack.ss_sp);
}

/*
**  END OF CODE FOR SOLARIS!!
*/

#else 

/*
**  THIS IS CODE FOR PRE-SOLARIS SUNOS!!
*/
void
MY_setjmp(jbuf,stack_top,start_thread,func,arg)
int *jbuf;
any_t (*start_thread)();
long stack_top;
long *arg;
long func;
{
    jbuf[0] = (int) start_thread;
    jbuf[1] = stack_top;
    jbuf[2] = func;
    jbuf[3] = (int) arg;
}

int sp;

void
MY_longjmp(jbuf)
int *jbuf;
{
    asm("t	0x03");
    asm("sub %sp,64,%sp");
    asm("ld	[%i0+4],%sp");
    asm("ld	[%i0+8],%o0");
    asm("ld	[%i0+12],%o1");
    start_thread((int (*)()) jbuf[2], (any_t)jbuf[3]);
}

void
fix_jbuf(t, func, arg)
cthread_t	t;
any_t 	(*func)();
long 	*arg;
{
    int i;

    for(i=0; i<9 ; i++) {
	t->jbuf[i] = 0;
    }
    MY_setjmp(t->jbuf,(long)(t->stack_top), (any_t(*)())start_thread, 
	      (long) func, arg);
}

void
DISPATCH(thread)
cthread_t thread;
{
    if ((thread)->already_started) { 
	DBG2("calling longjmp, buf[1] is %lx thread %lx\n",
	       (long)(thread)->jbuf[1], (long)thread);
	((thread)->jbuf)[1] = 0;
	longjmp((thread)->jbuf, 1);
    } else {
	fix_jbuf(thread, thread->func, (long *)thread->arg);
	DBG2("calling MY_longjmp, buf[1] is %lx thread %lx\n",
	       (long)(thread)->jbuf[1], (long)thread);
	(thread)->already_started = 1;
	MY_longjmp((thread)->jbuf,1);
    }
}

void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];

    if(setjmp(current_thread->jbuf) == 0) {
	/* 
	**  0 return from setjmp the first time the buffer is set.
	**  value is non-zero when we longjmp back here
	*/
	(func)(arg);

	/* func should never return */
	assert(FALSE);
    }
}

void *
get_sp_from_context(context_ptr)
cthread_context *context_ptr;
{
    return(context_ptr[1]);
}

/*
**  END OF CODE FOR PRE-SOLARIS SUNOS!!
*/
#endif
