/*
 * simple_queue.h
 */

#ifndef SIMPLE_QUEUE_H
#define SIMPLE_QUEUE_H

#define MAXTHREADS      50

typedef struct {
        struct cthread * queue[MAXTHREADS];
        int head,tail;
}simple_queue;

#define SIMP_Q_INIT(q) (q).head = (q).tail = 0
#define SIMP_Q_ADD(q, elem) ((q).queue)[((q).tail)] = elem; \
                             if ((q).tail == (MAXTHREADS-1)) (q).tail = 0; \
                             else ((q).tail)++
#define SIMP_Q_REMOVE(q, elem) elem = ((q).queue)[((q).head)]; \
                             if ((q).head == (MAXTHREADS-1)) (q).head = 0; \
                             else ((q).head)++
#define SIMP_Q_EMPTY(q) ((q).head == (q).tail)

typedef struct  lock_queue {
        LOCK    lqlock;
        simple_queue   fifo;
} *lock_queue_t;

struct cthread *
  lock_queue_head ARGS((lock_queue_t q));

struct cthread *
  lock_dequeue ARGS((lock_queue_t lq));

void
  lock_enqueue ARGS((lock_queue_t lq,
		     cthread_t litem));


#endif
