/*
 * simple_queue.c
 * Only used by cf_lock?
 */
#include "config.h"
#include "general.h"
#include "arch_sync.h"
#include "queue.h"

#include "cf_lock.h"


/* forward declarations */
struct cthread;

struct cthread *
  lock_queue_head(q)
lock_queue_t  q;
{
        register struct cthread * item;
        register        LOCK    *lptr;

        lptr = (LOCK *)(&q->lqlock);
        cthread_spin_lock(lptr);
	if ((q->fifo).head == (q->fifo).tail) item = 0;
        else item = ((q->fifo).queue)[(q->fifo).head];
        cthread_spin_unlock(lptr);
        return(item);
}

struct cthread *
  lock_dequeue(lq)
lock_queue_t  lq;
{
        register struct cthread * item;
        register        LOCK    *lptr;

        lptr = (LOCK *)(&lq->lqlock);
        cthread_spin_lock(lptr);
	SIMP_Q_REMOVE(lq->fifo, item);
        cthread_spin_unlock(lptr);
        return(item);
}

void
lock_enqueue(lq, litem)
lock_queue_t  lq;
struct cthread * litem;
{
        register        LOCK    *lptr;

        lptr = (LOCK *)(&lq->lqlock);
        cthread_spin_lock(lptr);
        SIMP_Q_ADD(lq->fifo, litem);
        cthread_spin_unlock(lptr);
}

