/*
**   machine specific defines for synchronization on the SGI
*/
#ifndef __SGI_SYNC_H
#define __SGI_SYNC_H
#include <task.h>
#include <ulocks.h>

extern usptr_t             *mem_handle, *monmem_handle;

typedef ulock_t  LOCK;
typedef	LOCK	*LOCK_T;

#define	LOCK_INIT(l)	{                                           \
			 if ((l = usnewlock(mem_handle)) == NULL) { \
				perror("Arena Full. Can't allocate lock\n");  \
				exit(1);            \
			  }                                         \
			 usinitlock(l);                              \
		        }

#define	M_LOCKED        1

typedef short atom_int;

/*
** the defines below this are used only in sync.c
*/

extern int TRY_TO_LOCK ARGS((LOCK *l));

#define ATOM_ADD_LOCK ss_lock

#define	SPIN_LOCK(sl)	while (TRY_TO_LOCK(sl) != M_LOCKED)

#define	SPIN_UNLOCK(sl)   usinitlock(*sl)

#define	MUTEX_LOCK(m)	while (TRY_TO_LOCK(m) != M_LOCKED) internal_cthread_yield()

#define	MUTEX_UNLOCK(m) usinitlock(*m)

#endif
