#include <sys/types.h>
#include <stdio.h>
#include <setjmp.h>

#include "assert.h"
#include "general.h"
#include "internal.h"
#include "sgi_init.h"
#include "hwlib.h"

/* defined in threads.c */
void start_thread ARGS((any_t (*func)(), any_t arg));
void start_threadV ARGS((int	(* func)(), int	n, any_t arg));
extern cthread_t current_thread_array[MAX_PROC];

#define         STACK_POINTER   JB_SP

#define ALIGNED_STACK(stack) (any_t)((((long)(stack))/8)*8 - 8)

int TRY_TO_LOCK(l)
LOCK *l;
{
    return  uscsetlock(*l,1);
}

void
start_fresh_thread(t, func, arg)
cthread_t	t;
any_t 	(*func)();
long 	*arg;
{
    int		result;
    unsigned long *stack;
    unsigned long copy_stack[16];

    DBG("in start fresh thread");
    if ((result = setjmp(t->jbuf)) != 0) {
	cthread_t current_thread = current_thread_array[virtual_processor()];
	DBG2("In StartFreshThread before StartThread, func is %lx arg is %lx\n",
	     (long)func, (long)arg);
	start_thread(current_thread->func, (any_t)(current_thread->arg));
	printf("PANIC: Error in thread creation\n");
	exit(0);
    } else {
	int i;
	stack = (unsigned long *) t->jbuf[STACK_POINTER];
	for(i=0; i< (sizeof(copy_stack)/sizeof(copy_stack[0])); i++) {
	    copy_stack[i] = stack[i];
	}
	t->jbuf[STACK_POINTER] = (long)t->stack_top;
	stack = (unsigned long *) t->jbuf[STACK_POINTER];
	for(i=0; i< (sizeof(copy_stack)/sizeof(copy_stack[0])); i++) {
	    stack[i] = copy_stack[i];
	}
	DBG1("Longjmping back to start_fresh_thread with stack %x\n",
	     t->jbuf[STACK_POINTER]);
	longjmp(t->jbuf, 1);
    }
}

void
DISPATCH(thread)
cthread_t thread;
{
    if ((thread)->already_started) { 
	DBG2("calling longjmp, buf[1] is %lx thread %lx\n",
	       (long)(thread)->jbuf[1], (long)thread);
	longjmp((thread)->jbuf, 1);
    } else {
	DBG1("calling fixjbuf for thread %lx\n", (long)thread);
	(thread)->already_started = 1;
	start_fresh_thread(thread, thread->func, thread->arg);
    }
}

void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];
    if(setjmp(current_thread->jbuf) == 0) {
	/* 
	**  0 return from setjmp the first time the buffer is set.
	**  value is non-zero when we longjmp back here
	*/
	(func)(arg);

	/* func should never return */
	assert(FALSE);
    }
}

void *
get_sp_from_context(context_ptr)
cthread_context *context_ptr;
{
    return(context_ptr[STACK_POINTER]);
}

