/*
**    THIS IS AN UNTESTED REPOSITORY OF Sequent Symmetry SPECIFIC CODE.
**      This code was extracted from init.c to isolate machine dependencies.
**	It has not even been compiled on the Sequent Symmetry.
*/ 

#include	<stdio.h>
#include	<signal.h>

#ifdef WITH_MONITOR

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/fcntl.h>

#include "monitor.h"
#endif WITH_MONITOR

#include	<sys/wait.h>

#include	<signal.h>
#include	<sys/tmp_ctl.h>
#include	<parallel/microtask.h>

#include	"results.h"
#include	"general.h"
#include	"idebug.h"
#define		LOGICAL_PROCESSOR	int
typedef		LOGICAL_PROCESSOR		*convert;
#include	"init.h"
#include	"lock.h"
#include	"queue.h"
#include	"sync.h"
#include	"internal.h"
#include	"memalloc.h"
#include	"cth_sched.h"
#include	"hwlib.h"
#include	"sched_utils.h"
typedef long *process_table_t;

shared int real_num_of_procs;

extern void monitorinit ARGS((int procs));
static void sequent_monitorinit ARGS((int procs));

RESULT
doinit(procs,start_func,proc_list)
int 		procs;
int		(*start_func)();
proc_list_t     proc_list;
{
   int			wid, i, chid, node, size, kres, count;
   long			*shared_shorts;
   long                 *tmp_shared_shorts;
   u_char               *tmp_pds;
   RESULT		tmp;
   process_table_t	pptr;
   int 			tot_size;

   union wait		stat;

#ifdef WITH_MONITOR
   sequent_monitorinit(procs);
#endif WITH_MONITOR

   size = MAX_PROC*sizeof(LOGICAL_PROCESSOR);

   phys_to_logical = allocate_and_share(size, -1);

   count = procs; 

   shared_shorts = (long *)allocate_and_share(SHARED_SHORT_SPACE,-1);

   num_of_procs		= &real_num_of_procs;
#ifdef WITH_MONITOR
   *num_of_procs        = count - 1;
#else WITH_MONITOR
   *num_of_procs        = count;
#endif WITH_MONITOR
   total_threads	= (short *)(shared_shorts++);
   total_active		= (short *)(shared_shorts++);
   *total_threads	= 0;
   *total_active	= 0;
   sync_init		= (short *)(shared_shorts++);
   *sync_init		= count;
#ifdef WITH_MONITOR
   monitor_monitor_status      = (short *)(shared_shorts++);
   *monitor_status     = (short) MONITOR_NOT_INITIALIZED;
#endif WITH_MONITOR
   ss_lock              = (LOCK *)(shared_shorts++);
   LOCK_INIT(*ss_lock);

   LOCK_INIT(print_sema);

   size = count * sizeof(struct local_info);

   processor = (struct local_info *)allocate_and_share(size,-1);

   /*
    * Allocate and inherit the processes table. Used in termination 
    * process. Implicit assumption: 
    *	PROCESSES_TABLE_SIZE > MAX_PROCESSORS * sizeof(process_t) 
    */

   processes = (process_table_t)allocate_and_share(PROCESSES_TABLE_SIZE,-1);

   DBG("Before init_convert\n");
   if((tmp = init_convert(proc_list)) != T_SUCCEED)
     return(tmp);
   DBG("After init_convert\n");

   DBG("Before initializing memory\n");
   if((tmp = meminit()) != T_SUCCEED)
      return(tmp);

   DBG("memory initialized\n");

#ifdef WITH_MONITOR
   Set_global_init(mon_sched_conf, monitor_global_init);
   Set_vproc_init(mon_sched_conf, monitor_vproc_init);
   Set_thread_init(mon_sched_conf, 0);
   Set_get_thread(mon_sched_conf, monitor_get_thread);
   Set_put_thread(mon_sched_conf, monitor_put_thread);
   Set_empty_readyq(mon_sched_conf, monitor_empty_readyq);
   Set_schedule(mon_sched_conf, monitor_schedule);
   Set_proc_idle(mon_sched_conf, 0);
   install_scheduler(*num_of_procs, *num_of_procs, &mon_sched_conf);
#endif WITH_MONITOR

   DBG("Before procinit \n");
   for (node=0; node < count; node++) {
      procinit(node);
   }

   DBG("Per processor structures inited\n");


     m_set_procs(count);
     m_fork(child_init,0,start_func);
          printf(
               "This Shouldn't happen, Returned from schedule_init in Doinit\n");
          exit(1);

     /*  
      * Here is the parent process which will fork the rest of the children
      * and it is going to wait for them to terminate.
      */ 
}

RESULT
init_convert(proc_list)
proc_list_t proc_list;
{
     int       i, j, count;

     for(i = 0; i < MAX_PROC; i++)
          phys_to_logical[i] = -1;

     /* if the processor is online, enter in the conversion table */
     j = 0;
     for (i=0; i<MAX_PROC; i++)
          if (tmp_ctl(TMP_QUERY, i) == TMP_ENG_ONLINE) {
               phys_to_logical[i] = j;
               processor[j++].logical_to_phys = i;
        }

     return(T_SUCCEED);
} /* init_convert */

check_num_procs(procs)
int procs;
{ /* Get the number of processors online */

    int count,online;
    online = cpus_online() - 1; /* Sequent restriction for
                 	           the number to be 1 less
				   than the max. no. of online 
				   processors */
    DBG1("AAA:No of online processors are %d",online + 1);
    DBG1("---says node no: %d\n",m_get_myid());

     if(proc_list == DEFAULT_PROC_LIST)
	     count = online;
     else if (procs > online ) { 
             error_exit("AAS", "Value of no of processors is more than expected",0, NO_NODE, NO_SIZE);
     }
     else count = procs;
     procs = count;  /* Temporary hack */
}

struct cthread;


#define		FRAME_POINTER	3
#define		STACK_POINTER	4
#define		PROGRAM_COUNTER	5

/*
 * fix_jbuf.c
 * Contains the function which sets the jump buffer initially. It is
 * highly machine depented so it was separated from the rest of the
 * library.
 *
 * Modification history:
 *
 * 1.0	01-Nov-88      	Initial release (MACH).
 * 1.1	01-Dec-88       Added the #ifdef PROFILE and #ifdef FAST switch to
 *			set the jump buffer in "_setjmp()" format.
 * 1.2	13-May_89	(Ahmed Gheith) Added variable args fork.
 * 1.3   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.4   Bodhi Mukherjee	Added Implementation for Sequent.
 * 1.5   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.6   Bodhi Mukherjee	Added Implementation for Sun3/86.
 *
 */

#include	<stdio.h>
#include "results.h"
#include "general.h"
#include	"fix_jbuf.h"

#ifdef	FAST
#include	"fast.h"
#endif	FAST

#include	"lock.h"
#include	"queue.h"
#include	"sync.h"
#include	"internal.h"
#include	"hwlib.h"

extern	any_t	start_thread();
extern	any_t	start_threadV();
extern 		internal_cthread_exit();
extern		shouldnt ARGS((char *msg));

void
fix_jbuf(t, func, arg)
cthread_t	t;
any_t 	(*func)();
long 	arg;
{
	long	*lptr;
	int		result;

   DBG3("In fix_jbuf(), func is %x, arg is %x, start_thread is %x\n"
      		, func, arg, start_thread);
fflush(stdout);
/* Check and see if this is really needed */
	if (setjmp(t->jbuf) != 0)
		shouldnt("Return from setjmp in fix_jbuf");

   lptr = (long *)t->stack_top;
   *lptr-- = 0;		/* A6 to previous frame (which doesn't exist)	*/
   *lptr-- = arg;			/* Arg 2			*/
   *lptr-- = (long)func;		/* Arg 1			*/

	*lptr-- = (long) internal_cthread_exit;
	t->jbuf[FRAME_POINTER] = (long) t->stack_top;
	t->jbuf[STACK_POINTER] = (long) lptr;
   	t->jbuf[PROGRAM_COUNTER] = (long)start_thread; /* jmp address. _setjmp */

} /* fix_jbuf */ 

static void
sequent_monitorinit(procs)
int procs;
{
    monitorinit(procs);
}
