/* sched_utils.h
   */
#ifndef SCHED_UTILS_H
#define SCHED_UTILS_H

#define NO_OF_SIGNALS 32

/* forward declarations */
struct cthread;
struct sched;

typedef struct sched_configuration {
                int  no_of_readyqs;
                int  no_of_threads;
                void *(*sched_global_init)();
                void *(*sched_vproc_init)();
                void *(*sched_thread_init)();
                void *(*sched_get_thread)();
                void *(*sched_put_thread)();
                void *(*sched_empty_readyq)();
                void *(*schedule)();
                void *(*proc_idle)();
                void (*alert_hndlrs[NO_OF_SIGNALS])();
} *sched_configuration_t;

/********************************************************/
/* The following macros set the different fields of a   */
/* scheduler configuration control block                */
/********************************************************/

#define Set_global_init(scb, fn) (scb).sched_global_init    = (fn)
#define Set_vproc_init(scb, fn) (scb).sched_vproc_init      = (fn)
#define Set_thread_init(scb, fn) (scb).sched_thread_init    = (fn)
#define Set_get_thread(scb, fn) (scb).sched_get_thread      = (fn)
#define Set_put_thread(scb, fn) (scb).sched_put_thread      = (fn)
#define Set_empty_readyq(scb, fn) (scb).sched_empty_readyq  = (fn)
#define Set_schedule(scb, fn) (scb).schedule                = (fn)
#define Set_proc_idle(scb, fn) (scb).proc_idle              = (fn)
#define Set_alert_handler(scb, signo, fn) ((scb).alert_hndlrs)[(signo)] = (fn)

/*
 * Scheduler related functions
 */

#define Get_Shared_Memory(size, node) allocate_and_share((size),(node))

extern int scb_size();

extern void (**cthread_in_schedule_function)();

/********************************************************/
/* Creates and Initializes a no. of ready queues in     */
/* a node                                               */
/********************************************************/
int
  allocate_and_init_readyqs ARGS((struct sched * scb,
				  int node,
				  int no_of_qs));

/********************************************************/
/* Creates and Initializes a free queue in a node	*/
/********************************************************/
int
  allocate_and_init_freelist ARGS((struct sched * scb,
				   int node,
				   int no_of_threads));

/********************************************************/
/* Initializes a scheduler  control block		*/
/********************************************************/
struct sched *
  allocate_and_init_scb ARGS((int node,
			      int no_of_qs,
			      int no_of_threads));

/********************************************************/
/* Initializes a scheduler  configuration  block	*/
/********************************************************/
void
  init_sched_config_block ARGS((sched_configuration_t scb));

/********************************************************/
/* The following function is used as the default        */
/* function when the optional function scb->schedule is */
/* NULL              					*/
/********************************************************/
void 
  default_schedule();

/********************************************************/
/* The following function is used by schedulers to 	*/
/* dispatch (begin running) threads			*/
/********************************************************/
void
  sched_dispatch();

/*
 * QUEUE FUNCTIONS:
 */

/********************************************************/
/* FIFO queue handling functions 			*/
/********************************************************/

#define Fifo_init(lq) locked_queue_init((lq))
#define Fifo_enqueue(lq, litem) locked_enqueue((lq), (litem))
#define Fifo_dequeue(lq) locked_dequeue((lq))
#define Fifo_emptyq(lq) ((lq)->lcqueue.first == 0)



extern void
install_scheduler ARGS((int from_node, int to_node, 
			sched_configuration_t this_scheduler));

extern void
sched_relinquish_processor();
#endif
