#ifndef SCHED_IO_LOCAL_H
#define SCHED_IO_LOCAL_H
#include "results.h"
#include "general.h"

#define ATOM

#define IO_YIELD(s, io_type) \
                    if( register_IO(s, io_type) >= 0) {\
                       swap_context_with_func(queue_io_and_schedule, NULL);\
						     }



extern void swap_context_with_func ARGS((void (*func)(),void *arg));
extern void queue_io_and_schedule ARGS(());
extern int register_IO ARGS((int s, int io_type));

extern private locked_queue_t   local_thread_queue[MAX_PROC];
extern cthread_t current_thread_array[MAX_PROC];
extern private struct sched             *local_scheduler[MAX_PROC];

extern int SIGPIPE_error_flag;
extern fd_set            *global_socket_list;
extern atom_int          *global_socket_count;

extern mutex_t           global_socket_lock;
extern SocketDescriptor  *socket_descriptor_list;
extern SocketDescriptor  **socket_descriptors;


#endif
