#ifndef _SCHED_IO_H_
#define _SCHED_IO_H_

#include "config.h"
#ifdef STDC_HEADERS
#include <stdarg.h>
#else
#include <varargs.h>
#endif
#include "general.h"
#include "sched_utils.h"

typedef int (*SysCall)(int, ...);

#ifndef AF_NULL
#define AF_NULL -1
#endif
#ifndef PF_LOCAL
#define PF_LOCAL -1
#endif

/* depends on max. bit set in fcntl.h */

#define O_THREADCONTROL 0x1000

typedef struct _socket_descript_ {
  int domain;
  int type;
  int protocol;
  int flags;
  int state;
  int duplicates;
  SysCall syscall; 
} SocketDescriptor;

void check_pending_io ARGS(());
int  init_sched_io ARGS((sched_info_t scb));
int  init_global_io ARGS(( ));
int  close_global_io ARGS(( ));
int  sched_io_has_error ARGS((int fd));
int  io_info_size ARGS(());
#endif   /* _SCHED_IO_H_ */
