#ifndef SCHED_INTERF
#define SCHED_INTERF
#include <signal.h>
#define NO_OF_SIGNALS 32
typedef struct sched_configuration {
                int  no_of_readyqs;
                int  no_of_threads;
                void *(*sched_global_init)();
                void *(*sched_vproc_init)();
                void *(*sched_thread_init)();
                void *(*sched_get_thread)();
                void *(*sched_put_thread)();
                void *(*sched_empty_readyq)();
                void *(*schedule)();
                void *(*proc_idle)();
                void (*alert_hndlrs[NO_OF_SIGNALS])();
} *sched_configuration_t;


typedef struct sched {
                locked_queue_t free_list; /* Scheduler free list of */
                locked_queue_t lqueue1; /* Scheduler ready queue */
                locked_queue_t lqueue2; /* Scheduler ready queue */
                LOCK sched_lock;
                int  (*sched_global_init)();
                int  (*sched_vproc_init)();
                int (*sched_thread_init)();
                int  (*sched_get_thread)();
                void (*sched_put_thread)();
                int  (*sched_empty_readyq)();
                void (*schedule)();
                int  (*alert_hndlr)();
} *sched_info_t;

/********************************************************/
/* The following macros set the different fields of a   */
/* scheduler configuration control block                */
/********************************************************/

#define Set_global_init(scb, fn) (scb).sched_global_init    = (fn)
#define Set_vproc_init(scb, fn) (scb).sched_vproc_init      = (fn)
#define Set_thread_init(scb, fn) (scb).sched_thread_init    = (fn)
#define Set_get_thread(scb, fn) (scb).sched_get_thread      = (fn)
#define Set_put_thread(scb, fn) (scb).sched_put_thread      = (fn)
#define Set_empty_readyq(scb, fn) (scb).sched_empty_readyq  = (fn)
#define Set_schedule(scb, fn) (scb).schedule                = (fn)
#define Set_proc_idle(scb, fn) (scb).proc_idle              = (fn)
#define Set_alert_handler(scb, signo, fn) ((scb).alert_hndlrs)[(signo)] = (fn)

extern install_scheduler(/* from_node, to_node, this_scheduler */);
/*
int from_node, to_node;
sched_info_t this_scheduler;
*/

#endif SCHED_INTERF
