#include <sys/types.h>
#include <stdio.h>
#include <setjmp.h>
#include <ulimit.h>

#include "assert.h"
#include "general.h"
#include "internal.h"
#include "hwlib.h"
#include "rs6000_init.h"

/* AIX hack variables and definitions */

extern char *st_limit;
extern int getpagesize();

/* defined in threads.c */
void start_thread ARGS((any_t (*func)(), any_t arg));
void start_threadV ARGS((int	(* func)(), int	n, any_t arg));
extern cthread_t current_thread_array[MAX_PROC];
extern void child_exit ARGS((int));

#define         STACK_POINTER     3
#define         LINK_POINTER     23
#define         LINK_POINTER2    62
#define         TABLE_OF_CONTENTS 4

#define ALIGNED_STACK(stack) (any_t)((((long)(stack))/8)*8 - 8)

extern int cs();

int TRY_TO_LOCK(l)
LOCK *l;
{
    return cs(l, 0, 1);  /* compare with 0, store 1 if equal */
}

void
start_fresh_thread(t, func, arg)
cthread_t	t;
any_t 	(*func)();
long 	*arg;
{
    int		result;
    unsigned long *stack;
    unsigned long copy_stack[20];

    DBG("in start fresh thread");
    DBG2("In StartFreshThread before StartThread, func is %x arg is %x\n",
	     (int)func, (int)arg);
    if ((result = setjmp(t->jbuf)) != 0) {
	/*
	** Don't rely on arguments or local variables...   
	**  They're not there 'cause we messed with things.
	*/
        int proc = virtual_processor();
	DBG2("In StartFreshThread before StartThread, func is %x arg is %x\n",
	     (int)current_thread_array[proc]->func, 
	     (int)current_thread_array[proc]->arg);
	start_thread(current_thread_array[proc]->func, 
		     (any_t)(current_thread_array[proc]->arg));
	printf("PANIC: Error in thread creation\n");
	child_exit(0);
    } else {
	int i;
	/* Hold jbuf addr in a register.  
	   We'll trash the stack later and not be able to get to it. */
	register cthread_context jbuf = t->jbuf;
	stack = (unsigned long *) jbuf[STACK_POINTER];
	for(i=0; i< (sizeof(copy_stack)/sizeof(copy_stack[0])); i++) {
	    copy_stack[i] = stack[i];
	}
	jbuf[STACK_POINTER] = (long)t->stack_top;
	stack = (unsigned long *) jbuf[STACK_POINTER];
	for(i=0; i< (sizeof(copy_stack)/sizeof(copy_stack[0])); i++) {
	    stack[i] = copy_stack[i];
	}
	DBG1("Longjmping back to start_fresh_thread with stack %lx\n",
	     (long) jbuf[STACK_POINTER]);

	/* fool the longjump into thinking we've got what it defines to be
	   a "reasonable" stack pointer by loading a value that's one 
	   page above the stack limit (st_limit set in rs6000_init.c)  */
	asm volatile("lx 1,0,%0" :/*no outputs*/: "r" (&st_limit) : "1");
	longjmp(jbuf, 1);
    }
}

void
DISPATCH(thread)
cthread_t thread;
{
    if ((thread)->already_started) { 
	/* Hold jbuf addr in a register.
	   We'll trash the stack later and not be able to get to it. */
	register cthread_context jbuf = (thread)->jbuf;
	DBG2("calling longjmp, buf[1] is %lx thread %x\n",
	       (long)jbuf[1], (int)thread);
	jbuf[1] = 0;
	/* fool the longjump into thinking we've got what it defines to be
	   a "reasonable" stack pointer by loading a value that's one 
	   page above the stack limit */
	asm volatile("lx 1,0,%0" : : "r" (&st_limit) : "1");
	longjmp(jbuf, 1);
    } else {
	(thread)->already_started = 1;
	DBG3("calling start_fresh thread %lx, func = %lx, arg = %lx\n", 
	     (long)thread, (long)thread->func, (long)thread->arg);
	start_fresh_thread(thread, thread->func, thread->arg);
    }
}

void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];

    if(setjmp(current_thread->jbuf) == 0) {
	/* 
	**  0 return from setjmp the first time the buffer is set.
	**  value is non-zero when we longjmp back here
	*/
	(func)(arg);

	/* func should never return */
	assert(FALSE);
    }
}

void *
get_sp_from_context(context_ptr)
cthread_context *context_ptr;
{
    return(context_ptr[STACK_POINTER]);
}

