/*
 * queue.h
 * Modification history:
 *
 * 1.0	3-May-88	Initial release.
 *
 */

#ifndef QUEUE_H
#define QUEUE_H

/* forward declarations */
struct cthread;

typedef	struct	cth_queue {
	struct	queue_item	*first;
	struct	queue_item	*tail;
} *cth_queue_t;

typedef	struct	queue_item {
	struct	queue_item	*next;
} *queue_item_t;

typedef	struct	locked_queue {
	LOCK	lqlock;
	struct	cth_queue	lcqueue;
} *locked_queue_t;


void
  queue_init ARGS((cth_queue_t q));


queue_item_t
  dequeue ARGS((cth_queue_t q));

queue_item_t
  dequeue_item ARGS((cth_queue_t     q,
		     queue_item_t item));

void
  enqueue ARGS((cth_queue_t	q,
		queue_item_t item));

queue_item_t
  queue_head ARGS((cth_queue_t q));

int
  queue_len ARGS((cth_queue_t q));

queue_item_t
  locked_queue_head ARGS((locked_queue_t q));

void
  queue_exec ARGS((int (*func)(),
		   cth_queue_t q));

void
  locked_queue_exec ARGS((int (*func)(),
			  locked_queue_t lq));

void
  locked_queue_init ARGS((locked_queue_t lq));

queue_item_t
  locked_dequeue ARGS((locked_queue_t lq));

void
  locked_enqueue ARGS((locked_queue_t lq,
		       queue_item_t litem));

queue_item_t
  spin_locked_dequeue ARGS((locked_queue_t lq));

void
  spin_locked_enqueue ARGS((locked_queue_t lq,
			    queue_item_t litem));
/*
void
  t_will_block ARGS((locked_queue_t lqueue,
		     cth_queue_t tqueue,
		     LOCK_T slock));
*/

#endif
