/*
 * queue.c
 * Queueing routines.
 *
 * Modification history:
 *
 * 1.0	3-May-88	Initial release.
 * 1.1	1-Dec-88 	Some "#ifdef PROFILE" statements were added.
 * 1.2   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.3   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.4   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.5   Bodhi Mukherjee	Added Implementation for Sequent.
 *
 */

#include "results.h"
#include "general.h"
#include "lock.h"
#include "queue.h"
#include "internal.h"
#include "sync.h"
#include "arch_init.h"

extern	private	locked_queue_t		local_thread_queue[MAX_PROC];
extern  cthread_t           	current_thread_array[MAX_PROC];

void
queue_init(q)
cth_queue_t	q;
{
	q->first = 0;
	q->tail = 0;
}

queue_item_t
dequeue(q)
cth_queue_t	q;
{
	queue_item_t	item;

	if((item = q->first) != 0 && ((q->first = item->next) == 0))
		q->tail = 0;
	return(item);
}

queue_item_t
dequeue_item(q, item)
cth_queue_t	q;
queue_item_t	item;
{
	queue_item_t	last =0;
	queue_item_t	elem = q->first;

	while (elem != 0) {
	    if (elem == item) break;
	    last = elem;
	    elem = elem->next;
	}

	if(elem == 0) return 0;;

	if (last != 0) {
	    last->next = elem->next;
	} else {
	    q->first = elem->next;
	}
	if (elem->next == 0) {
	    q->tail = last;
	}
	return(item);
}

int
queue_len(q)
cth_queue_t q;
{
    int len=0;
    queue_item_t item;
    item = q->first;
    while(item != 0) {
	len++;
	item = item->next;
    }
    return len;
}

void
enqueue(q,item)
cth_queue_t	q;
queue_item_t	item;
{
	item->next = 0;
	if (q->tail == 0)
		q->first =  item;
	else
		q->tail->next = item;
	q->tail = item;
}

queue_item_t
  queue_head(q)
cth_queue_t	q;
{
	return(q->first);
}

queue_item_t
  locked_queue_head(q)
locked_queue_t	q;
{
        queue_item_t    item;
        LOCK    *lptr;

	lptr = (LOCK *)(&q->lqlock);
        cthread_spin_lock(lptr);
	item = (q->lcqueue).first;
        cthread_spin_unlock(lptr);
        return(item);
}

void
  queue_exec(func, q)
int		(*func)();
cth_queue_t	q;
{
	queue_item_t	qtmp;

	qtmp = q->first;
	while (qtmp != 0){
		(*func)(qtmp);
		qtmp = qtmp->next;
	}
}

void
locked_queue_exec(func,lq)
int				(*func)();
locked_queue_t	lq;
{
	LOCK	*lptr;
	int	proc = virtual_processor();

	if((lptr = (LOCK *)&lq->lqlock) == &local_thread_queue[proc]->lqlock)
		cthread_spin_lock(lptr);
	else
		internal_mutex_lock(lptr);

	queue_exec(func, &lq->lcqueue);

	if(lptr == &local_thread_queue[proc]->lqlock)
		cthread_spin_unlock(lptr);
	else
		internal_mutex_unlock(lptr);
}

void
locked_queue_init(lq)
locked_queue_t	lq;
{
	LOCK_INIT(lq->lqlock);
	queue_init(&lq->lcqueue);
}

queue_item_t
locked_dequeue(lq)
locked_queue_t	lq;
{
    queue_item_t	item;
    LOCK	*lptr = (LOCK *) &lq->lqlock;
    int proc = virtual_processor();
    cthread_t current_thread = current_thread_array[proc];

	
    if ((lptr == &local_thread_queue[proc]->lqlock) || 
	(current_thread == NULL)) {
	cthread_spin_lock(lptr);
    } else {
	internal_mutex_lock(lptr);
    }
    
    item = dequeue(&lq->lcqueue);
    
    if ((lptr == &local_thread_queue[proc]->lqlock) || 
	(current_thread == NULL)) {
	cthread_spin_unlock(lptr);
    } else {
	internal_mutex_unlock(lptr);
    }
    return(item);
}

void
locked_enqueue(lq, litem)
locked_queue_t	lq;
queue_item_t	litem;
{
	LOCK	*lptr;
	int proc = virtual_processor();
	if((lptr = (LOCK *)&lq->lqlock) == &local_thread_queue[proc]->lqlock)
		cthread_spin_lock(lptr);
	else
		internal_mutex_lock(lptr);

	enqueue(&lq->lcqueue, litem);

	if(lptr == &local_thread_queue[proc]->lqlock)
		cthread_spin_unlock(lptr);
	else
		internal_mutex_unlock(lptr);
}

queue_item_t
spin_locked_dequeue(lq)
locked_queue_t	lq;
{
	queue_item_t	item;
	LOCK	*lptr;

	lptr = (LOCK *)(&lq->lqlock);
	cthread_spin_lock(lptr);
	if((item = (lq->lcqueue).first) != 0) 
	    if (((lq->lcqueue).first = item->next) == 0) (lq->lcqueue).tail = 0;
	cthread_spin_unlock(lptr);
	return(item);
}

void
spin_locked_enqueue(lq, litem)
locked_queue_t	lq;
queue_item_t	litem;
{
	LOCK	*lptr;

	lptr = (LOCK *)(&lq->lqlock);
	cthread_spin_lock(lptr);
	enqueue(&lq->lcqueue, litem);
	cthread_spin_unlock(lptr);
}

/*
void
t_will_block(lqueue, tqueue, slock)
locked_queue_t	lqueue;
cth_queue_t	tqueue;
LOCK_T		slock;
{
	queue_item_t	item;

	item = locked_dequeue(lqueue);
	cthread_spin_lock(slock);
	enqueue(tqueue, item);
	cthread_spin_unlock(slock);
}

*/
