/*
 * printf.c
 * A silly version which provides atomic printf(). 
 * BE CAREFUL it works for up to 8 parameters.
 *
 * Modification history:
 *
 * 1.0		01-Nov-88      	Initial release (MACH).
 * 1.2   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.3   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.4   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.5   Bodhi Mukherjee	Added Implementation for Sequent.
 *
 */

#include <config.h>
#include <stdio.h>
#ifndef HAVE_WINDOWS_H
#include <unistd.h>
#endif
#include <varargs.h>

#include "general.h"
#include "lock.h"

extern int vfprintf();

#define		BUFF_LEN	255

char		buffer[BUFF_LEN];
long		*pptr;

extern	int dirty_print;

shared LOCK *print_sema;


void
yt_printf_lock()
{
    if (print_sema != NULL) {
	SPIN_LOCK(print_sema);
    }
}

void
yt_printf_unlock()
{
    if (print_sema != NULL) {
	SPIN_UNLOCK(print_sema);
    }
}

void
yt_printf(va_alist)
va_dcl
{
    va_list ap;
    char *format;
    if(!dirty_print) {
	yt_printf_lock();
    }
    va_start(ap);
    format = va_arg(ap, char*);
    vfprintf(stdout, format, ap);
    va_end(ap);
    if(!dirty_print) {
	yt_printf_unlock();
    }
}

void
aprintf_lock()
{
    if (print_sema != NULL) {
	SPIN_LOCK(print_sema);
    }
}

void
aprintf_unlock()
{
    if (print_sema != NULL) {
	SPIN_UNLOCK(print_sema);
    }
}

void
aprintf(va_alist)
va_dcl
{
    va_list ap;
    char *format;
    if(!dirty_print) {
	aprintf_lock();
    }
    va_start(ap);
    format = va_arg(ap, char*);
    vfprintf(stdout, format, ap);
    va_end(ap);
    if(!dirty_print) {
	aprintf_unlock();
    }
}

void
afprintf(va_alist)
va_dcl
{
    va_list ap;
    FILE *file;
    char *format;
    if(!dirty_print) {
	aprintf_lock();
    }
    va_start(ap);
    file = va_arg(ap, FILE*);
    format = va_arg(ap, char*);
    vfprintf(file, format, ap);
    va_end(ap);
    if(!dirty_print) {
	aprintf_unlock();
    }
}
