/* 
 * perror.c
 * Modification history:
 *
 * 1.0	20-May-88	Initial version.
 * 1.2   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.3   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.4   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.5   Bodhi Mukherjee	Added Implementation for Sequent.
 */

#include	<stdio.h>
#include	"results.h"
#include	"general.h"

void
cthread_perror(str, error_code)
string_t	str;
RESULT		error_code;
{
    if (str != NULL) {
	fprintf(stderr, "%s: ",str);
    } else {
	fprintf(stderr, ": ");
    }
    switch(error_code){
    case T_SUCCEED:	
	fprintf(stderr, "Succeeded\n");
	break;
    case T_NOMEMORY:
	fprintf(stderr, "Not enough memory remains\n");
	break;
    case T_NO_THREAD_QUEUED:
	fprintf(stderr, "No thread queued\n");
	break;
    case T_JOINING_OR_FREED:
	fprintf(stderr, "Joining or freed\n");
	break;
    case T_CANNOT_JOIN:
	fprintf(stderr, "Cannot join\n");
	break;
    case T_CANNOT_JOIN_MYSHELF:
	fprintf(stderr, "Cannot join myself\n");
	break;
    case T_ALREADY_INIT:
	fprintf(stderr, "Already initialized\n");
	break;
    case T_TOO_BIG_MEMORY_MODULE:
	fprintf(stderr, "Memory exponent requested will not contain this block\n");
	break;
    case T_BAD_REQUEST:
	fprintf(stderr, "Bad request\n");
	break;
    case T_SCHED_TOO_MANY_READYQS:
	fprintf(stderr, "Too many ready queues requested by scheduler\n");
	break;
    case T_SCHED_TOO_MANY_THREADS:
	fprintf(stderr, "Too many ready threads requested by scheduler\n");
	break;
    default:
	fprintf(stderr, "Error code %d\n",error_code);
	break;
    }
}
						
