
/* 
 * **   machine specific defines for synchronization for NT */

#ifndef __NT_SYNC_H
#define __NT_SYNC_H

#define LOCK    volatile int
typedef LOCK *LOCK_T;
#define LOCK_INIT(l)    (unsigned int)(l) = 0
#define M_LOCKED        0

typedef short atom_int;

/* 
 * ** the defines below this are used only in sync.c */

extern int TRY_TO_LOCK ARGS((LOCK * l));

#define ATOM_ADD_LOCK ss_lock

#ifdef SPIN_LOCK
#undef SPIN_LOCK
#endif
#define	SPIN_LOCK(sl)	while (TRY_TO_LOCK(sl) != M_LOCKED)

#define	SPIN_UNLOCK(sl)	LOCK_INIT(*sl)

#define	MUTEX_LOCK(m)	while (TRY_TO_LOCK(m) != M_LOCKED) internal_cthread_yield()

#define	MUTEX_UNLOCK(m)	LOCK_INIT(*m)

#endif
