
/* nt exception handlers */
#include "config.h"
#include <windows.h>
#include <process.h>
#include "general.h"
#include "internal.h"
#include "init.h"
#include "nt_init.h"

extern struct local_info *processor;
/****************************************************************
 ** This routine is called from an __except block	       **
 ** with the NT exception code as a parameter.  It returns     **
 ** the Cthreads child exit code for use by shutdown_processes **
 ****************************************************************/
int
handleException(DWORD exception)
{
    int node = virtual_processor();
    /* Any additional errors you would like to trap can be entered inside
     * * the switch */
    switch (exception) {
    case EXCEPTION_ACCESS_VIOLATION:
	/* Handle a memory access exception SIGSEG */
	printf("Memory Violation in processor %i\n", node);
	return (CHILD_MEMORY_VIOLATION);

    case EXCEPTION_FLT_STACK_CHECK:
    case EXCEPTION_STACK_OVERFLOW:
	/* Handle stack overflow */
	printf("Stack overflow detected in node %i\n", node);
	return (CHILD_STACK_OVERFLOW);

    case EXCEPTION_FLT_INVALID_OPERATION:
    case EXCEPTION_ILLEGAL_INSTRUCTION:
	/* handle illegal instruction SIGILL */
	printf("Illegal instruction executed in node %i\n", node);
	return (CHILD_SIGILL);

    default:
	printf("Unknown exception in processor %i\n", node);
	return (CHILD_UNKNOWN_ERROR);
    }
}

void
fill_sighandler_struct(node, alert_hndlrs)
int node;
HANDLERRETTYPE(*alert_hndlrs[NO_OF_SIGNALS]) ();
{
    /* not supported on NT */
    ;
}

void
setup_sigpipe_handler(hndlr)
void (*hndlr)();
{
    /* not supported on NT */
    ;
}

void
setup_sigalrm_handler(hndlr)
void (*hndlr)();
{
    /* not supported on NT */
    ;
}
