
/* nt_init.c */
#include	"config.h"
#include	<windows.h>
#include	"nt_init.h"
#include	<stdio.h>
#include	<signal.h>
#include	<string.h>
#include	<malloc.h>
#include	<sys/types.h>
#include	<winsock.h>
#include	<sys/timeb.h>
#include	<stdlib.h>
#include	<conio.h>
#include	<process.h>
#include	<assert.h>
#include	"results.h"
#include	"general.h"
#include	"init.h"
#include	"lock.h"
#include	"queue.h"
#include	"sync.h"
#include	"internal.h"
#include	"memalloc.h"
#include	"cth_sched.h"
#include	"hwlib.h"
#include	"sched_utils.h"
#include	"idebug.h"
#include	"threads.h"
#include	"sched_io.h"
#include	"monitor.h"

extern shared short *monitor_status;
extern shared mutex_t logicalTimeStamp_lock;
extern shared unsigned long *logicalTimeStamp_counter;
extern shared LOCK *print_sema;

/* these symbols needed from init.c */

typedef HANDLE process_t;
typedef process_t *process_table_t;

extern struct local_info *processor;
extern private locked_queue_t local_thread_queue[MAX_PROC];
extern private short threads_started;
extern int *num_of_procs;
extern atom_int *total_threads;
extern atom_int *total_active;
extern void *processes;		/* untyped version of typed_processes */
process_table_t typed_processes;	/* An array of the processes    */
extern shared long dynamic_memory_per_processor;
extern struct configuration config;	/* configuration        */
#define		NO_SIZE		-1
#define		NO_NODE		-1
extern shared mem_free_list_t *memory_pool;
extern int page_aligned_size ARGS((int));

LOCK *ss_lock;
extern cthread_t current_thread_array[MAX_PROC];
extern shared sched_info_t local_scheduler[MAX_PROC];

atom_int *sync_init;

#define MAX_WAIT_TIMEOUT	INFINITE
#define IN_MEMORY_HANDLE	0xFFFFFFFF

static void abnormal ARGS((WAIT_STAT_TYPE stat, int wid));
extern RESULT init_convert ARGS((int procs));

extern void monitorinit ARGS((int procs));
static void nt_monitorinit ARGS((int procs));
DWORD WINAPI child_init(LPVOID lpvThreadParm);
void relinquish_processor();
void child_exit ARGS((int));

static int use_shared_memory;
shared int real_num_of_procs;
static volatile int total_procs_exit = 0;
static int total_procs_forked = 0;
static int parent_waiting_the_end = 0;
static int parent_in_exit = 0;

/* NT Global values     */
typedef struct tparam {		/* have to use this to pass values to NT * 
				 * 
				 * * thread */
    void (*start_func) ();	/* NT threads can have only 1 argument, *
				 * * therfore */
    int node;			/* we will pass a pointer to this * *
				 * structure */
} tparam, *pparam;		/* If threads ever need more init data, *

				 * 
				 * * add it here */
DWORD dwThreadID[MAX_PROC];
HANDLE hshared_memory;		/* handle to shared memory */
HANDLE hMonitorMemory;		/* handle to monitor memory */
UCHAR *shm_base;		/* base address of memfile */
UCHAR *mon_base;		/* base address of monitor file */
unsigned long shm_offset;	/* offset into shared mem */
unsigned long mon_offset;	/* offset into monitor mem */
CRITICAL_SECTION cs;		/* critical section for use by lock */
						  /* If this program is *
						   * * ported to use * *
						   * mulitple processes */
						  /* rather than threads,
						   * * * this will need to 
						   * *  * become a mutex */

void shutdown_processes(int exitCode);
int total_procs;		/* this is global because we need it to *
				 * * find our virtual processor ID */
int mem_size;			/* this checks for memory overflow */

/************************************************************
 **  This routine simply aligns pages on correct boundary  **
 ************************************************************/
/* 
 * int page_aligned_size(int size) { int rem; if ((rem =
 * size%getpagesize()) != 0) return((size/getpagesize() + 1) *
 * getpagesize()); else return(size) ; } */

/**************************************************/
/** doinit begins the initialization of all nodes */
/** it spawns the child processes				  */
/** on the machine.	and sets the global data strct*/
/**************************************************/

int
master_on_exit()
{
    parent_in_exit = 1;
    DBG3("In 2master on exit, VP=%d, total= %d, exit=%d\n",
	 virtual_processor(), total_procs_forked, total_procs_exit);
    if (virtual_processor() == 0 &&
	total_procs_forked > 0 &&
	total_procs_exit != 0) {
	child_exit(0);
    }
    return 0;
}

RESULT
doinit(void (*start_func) (), int procs)
{
    int i, node;
    BOOL chid = FALSE;
    long *shared_shorts;
    LPVOID errorMsg;
    DWORD exitCode, wid;
    pparam pParameters;

    __try
    {
	InitializeCriticalSection(&cs);

	pParameters = malloc(sizeof(tparam)*MAX_PROC);
	total_procs = procs;

	if (monitoring_enabled) {
	    total_procs += number_of_lms;
	    if (steering_enabled)
		total_procs++;
	}
	/* create shared memory       */
	create_shared_arena(total_procs);

	if (monitoring_enabled)
	    nt_monitorinit(total_procs);

	shared_shorts = (long *) allocate_and_share(SHARED_SHORT_SPACE, -1);

	num_of_procs = &real_num_of_procs;
	*num_of_procs = procs;
	total_threads = (short *) (shared_shorts++);
	*total_threads = 0;
	total_active = (short *) (shared_shorts++);
	*total_active = 0;
	sync_init = (short *) (shared_shorts++);
	*sync_init = total_procs;
	monitor_status = (short *) (shared_shorts++);
	*monitor_status = (short) MONITOR_NOT_INITIALIZED;
	ss_lock = (LOCK *) (shared_shorts++);
	LOCK_INIT(*ss_lock);

	total_procs_forked = total_procs;
	total_procs_exit = total_procs;	/* for the overwritten "exit" */

	print_sema = (LOCK *) (shared_shorts++);
	*print_sema = 0;

	init_shared_data(total_procs);

	DBG1("Before procinit total_procs %d \n", total_procs);
	for (node = 0; node < total_procs; node++) {
	    procinit(node);
	    DBG1("procinit for node %d done \n", node);
	}

	DBG("Per processor structures inited\n");

	if (init_global_io() < 0)
	    exit(20);

	if (atexit((void*)master_on_exit) != 0) {
	    perror("atexit");
	}

	/* set up our parameter passing routine */
	assert(PROCESSES_TABLE_SIZE > MAX_PROC * sizeof(process_t));
	typed_processes = (process_table_t) processes;

	/* Spin off the virtual processors.  We use threads here because * 
	 * 
	 * * NT doesn't fork() */
	for (node = 1; node < total_procs; node++) {
	    pParameters[node].start_func = start_func;
	    pParameters[node].node = node;
	    /* On thread creation, we return the handle that will be used
	     * * * later to determine exit */
	    /* I am not using any security features.  If security added, * 
	     * 
	     * * modify the first 2 params */
/* if ((processes[node] = CreateThread(NULL, 0, child_init, (LPVOID) *
 * pParameters, */

	    if ((typed_processes[node] = (void*)
		 _beginthreadex(NULL, 0, child_init, 
				(LPVOID) &pParameters[node],
				0, &dwThreadID[node])) == 0) {
		perror("Create Virtual Processor failed");
		fprintf(stderr, "Can't support so many processes.  Reduce -num_procs.\n");
		shutdown_processes(THREAD_CREATE_FAIL);
	    }
	}

	pParameters[0].start_func = start_func;
	pParameters[0].node = 0;
	dwThreadID[0] = GetCurrentThreadId();

	child_init(&pParameters[0]);

	return 0;

	/* Now block this process until all the virtual processors are * * 
	 * done. Then check for abnormal exits.  We wait for multiple * *
	 * objects,  by using the TRUE parameter, we want to know when all 
	 * 
	 * *  * * are signalled (in this case all threads exit). We
	 * currently *  * wait for infinite time, but this could be
	 * adjusted by relacing * * infinite with some finite value */

	if ((wid = WaitForMultipleObjects(total_procs,
					  (CONST HANDLE *) typed_processes, TRUE, INFINITE)) == WAIT_FAILED) {
	    /* if wait fails, get code and display error */
	    exitCode = GetLastError();
	    printf("Internal Error : Thread Wait Failed with %d\n", exitCode);
	    FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_ALLOCATE_BUFFER,
	    NULL, exitCode, MAKELANGID(LANG_ENGLISH, SUBLANG_ENGLISH_US),
			  (LPTSTR) & errorMsg, 0, NULL);
	    printf("ERROR : %s\n", errorMsg);
	    LocalFree(errorMsg);
	    shutdown_processes(exitCode);
	}
	for (i = 0; i < total_procs; i++) {
	    GetExitCodeThread(typed_processes[i], &exitCode);
	    if (exitCode == CHILD_NORMAL_EXIT) {
		DBG2("Child %i terminated normally with retcode %d\n",
		     i, exitCode);
	    } else {
		/* Bad code so print message and shutdown */
		abnormal(i, exitCode);
		shutdown_processes(exitCode);
	    }
	}
	/* shut down the IO control */
	close_global_io();
	/* Leave the program normally */
	exit(0);
	return (0);		/* for the compiler, never reached */
    }

    __except(EXCEPTION_EXECUTE_HANDLER) {
	shutdown_processes(
			      handleException(GetExceptionCode()));
    }
}

extern
int
current_processor()
{
    return virtual_processor();
}

/***********************************************************/
/*** This routine creates a single processor identified by *
 *** the int node, running the thread start_func with args *
 *** arg.												   *
 ***********************************************************/
DWORD WINAPI
child_init(LPVOID lpvThreadParm)
{
    pparam tInfo;
    tparam thread_info;


    tInfo = (pparam) lpvThreadParm;
    thread_info.node = tInfo->node;
    thread_info.start_func = tInfo->start_func;
    DBG2("Creating virtual processor %i with initial thread %lx\n",
	 thread_info.node, thread_info.start_func);

    current_thread_array[virtual_processor()] = NULL;
    local_scheduler[virtual_processor()] = processor[virtual_processor()].scheduler;

    DBG3("In child %d, processor = %x, processes = %x\n",
	 virtual_processor(), (int) processor, (int) processes);
    DBG4("In child %d no_of_procs = %x *no_of_procs = %d mem_pool = %x\n",
	 virtual_processor(), (int) num_of_procs, *num_of_procs,
	 (int) memory_pool);

    if (local_scheduler[virtual_processor()]->sched_vproc_init != 0) {
	(local_scheduler[virtual_processor()]->sched_vproc_init) (virtual_processor());
    }
    threads_started = 1;
/*******************************************************************/
/* sync_init has to be equal to current_processor + 1 to make sure */
/* that all the child proceses wait till the child 0 is done       */
/* forking the init thread. This is necessary so that the monitor  */
/* thread doesn't get the chance to lock the list->lock before the */
/* init thread executes add_thread_to_lm_list                      */
/*******************************************************************/
    __try {

	while (*sync_init != virtual_processor() + 1) {
	    struct timeval delay_time;
	    int delay_unit = (*num_of_procs - virtual_processor());
	    delay_time.tv_sec = 0;
	    delay_time.tv_usec = delay_unit * 10;	/* return * *
							 * millisecs */
	    DBG3("Sync init = %d  current proc = %d delaying for %d\n", *sync_init,
		 virtual_processor(), delay_unit);
	    select(32, NULL, NULL, NULL, &delay_time);
	}

	start_proc_initial_thread(thread_info.start_func);

	atomadd(sync_init, -1);
	while (*sync_init != 0) {
	    struct timeval delay_time;
	    delay_time.tv_sec = 0;
	    delay_time.tv_usec = (*sync_init) * 10;	/* return * *
							 * millisecs */
	    DBG2("Sync post init = %d  current proc = %d\n",
		 *sync_init, virtual_processor());
	    select(32, NULL, NULL, NULL, &delay_time);
	}

	DBG1("Processor %i initialized. Starting our queue\n", virtual_processor());

	if ((thread_info.start_func == NULL) && (thread_info.node == 0)) {
	    DBG1("doing cthread_start. thread_info.start_func %lx\n",
		 thread_info.start_func);
	    current_thread_array[thread_info.node] = *initial_thread;
	    (*initial_thread)->already_started = 1;
	    swap_context_with_func((void (*)()) local_scheduler[thread_info.node]->schedule,
				   NULL);
	} else {
	    DBG1("doing cthread_init. thread_info.node %lx\n",
		 thread_info.node);
	    local_scheduler[thread_info.node]->schedule();
	}
	return (0);		/* for the compiler         */
    }
    __except(EXCEPTION_EXECUTE_HANDLER) {
	shutdown_processes(handleException(GetExceptionCode()));
    }
}

/**********************************************************/
/*** This routine creates the shared memory area using   **/
/*** the WIN32 shared memory files.  By specifying a     **/
/*** handle of 0xFFFFFFFF we make it in the phys swap	 **/
/*** file.  Each process can attach by using name        **/
/*** ".shm_mem".										 **/
/**********************************************************/
void
create_shared_arena(int procs)
{
    int size;
    int mem_size, tmp;
    int monitor_mem_size();

    mem_size = sizeof(struct mem_free_list);
    tmp = mem_size & 0x03;
    if (tmp != 0)
	mem_size += 4 - tmp;
    mem_size += dynamic_memory_per_processor;
    mem_size = procs * (mem_size + sizeof(mem_free_list_t));
    size = page_aligned_size(SHARED_SHORT_SPACE +
			     procs * sizeof(struct local_info) +
			     PROCESSES_TABLE_SIZE +
			     mem_size +
			     procs * (scb_size() +
				       (sizeof(struct locked_queue) +
					sizeof(locked_queue_t)) +
				      sizeof(struct locked_queue) +
				      config.threads_per_proc *
				      sizeof(struct cthread)) +
			     getpagesize());
    size = size * 2;
    DBG1("Shared arena size =  mem_size(%d) + \n", mem_size);
    DBG1("                     num_of_procs(%d) * (\n", procs);
    DBG1("                             queue_overhead(%d)\n",
	 scb_size() +
	 (sizeof(struct locked_queue) + sizeof(locked_queue_t)));
    DBG1("                             thread TCBs(%d))\n",
	 config.threads_per_proc * sizeof(struct cthread));
    DBG1("    		    + other stuff = total size (%d)\n", size);
    if (procs > 1) {
	use_shared_memory = 1;
	hshared_memory = CreateFileMapping((HANDLE) 0xFFFFFFFF, NULL,
				    PAGE_READWRITE, 0, size, ".shm_mem");

	if (hshared_memory == NULL) {
	    perror("SHared Memory GET failed!");
	    fprintf(stderr, "Possible cause:  Requested thread/processor/memory \
				configuration requires\n\tmore shared memory than is \
				available.  Reduce requirements.\n");
	    CloseHandle(hshared_memory);
	}
	shm_base = (UCHAR *) MapViewOfFile(hshared_memory, FILE_MAP_READ | FILE_MAP_WRITE,
					   0, 0, 0);
	shm_offset = 0;
    } else {
	use_shared_memory = 0;
	shm_base = (UCHAR *) malloc(size);
	shm_offset = 0;
    }
}

/***************************************************************************
 **	This routine allocates memory in the shared area					  **
 ***************************************************************************/
any_t
allocate_and_share(unsigned size, int node)
{
    UCHAR *address;
    address = (UCHAR *) ((int) shm_base + shm_offset);
    shm_offset = shm_offset + size;
    return ((any_t) address);
}

/****************************************************************************
 ** This routine allocates heap memory in local process					   **
 ****************************************************************************/
any_t
allocate_and_copy(unsigned size)
{
    char *address;

    if ((address = (char *) malloc(size)) == NULL) {
	perror("Internal allocate_and_copy");
	exit(10);
    }
    return ((any_t) address);
}

/****************************************************************************
 ** This routine allocates memory for the stack							   **
 ****************************************************************************/
char *
get_stack_memory(int size)
{
    return (char *) allocate_and_copy(size);
}

/*******************************************************************/
extern RESULT
init_convert(procs)
int procs;
{
    int i, j;

    /* if the processor is online, enter in the conversion table */
    j = 0;
    for (i = 0; i < procs; i++) {
	processor[j++].logical_to_phys = i;
    }
    return (T_SUCCEED);
}				/* init_convert */

/*****************************************************************************
 ** This routine handles abnormal process exit								**
 *****************************************************************************/
static void
abnormal(int node, int exitCode)
{

    if (exitCode == CHILD_SIGILL) {
	printf("Child died with illegal instruction signal SIGILL on logical proc %i\n",
	       node		/* ((long)pptr - (long)processes) / * *
				 * sizeof(process_t) */ );
    } else {
	printf("Child %d died with termination signal %d on logical proc %i\n",
	       node, exitCode);

    }
}

/********************************************************************************/
void
check_num_procs(procs)
int procs;
{
    int total_procs = procs;
    if (monitoring_enabled) {
	total_procs += number_of_lms;	/* procs reserved for monitoring */
	if (steering_enabled)
	    total_procs++;
    }
    if (total_procs > MAX_PROC) {
	fprintf(stderr, "Requested number of processors exceeds Cthreads internal limits\n");
	exit(11);
    }
}

/***************************************************************************************/
int
check_stack_size(size)
int size;
{
    size += getpagesize();	/* add one page for protection */

    /* round up to the nearest integral multiple of page size */
    if ((size % getpagesize()) != 0) {
	size = ((size / getpagesize()) + 1) * getpagesize();
    }
    return size;
}

/************************************************************************************
 * Allocate memory for monitor common structures from the monitor shared memory     *
 * mapped file																		*
 ************************************************************************************/
void *
allocate_monmem(int size, int node)
{
    long n;
    UCHAR *address;

    address = (UCHAR *) mon_base + mon_offset;
    if ((n = (unsigned long) address % sizeof(long))) {
	address += sizeof(long) - n;
	mon_offset += sizeof(long) - n;
    }
    mon_offset = mon_offset + size;
    if (((long) mon_offset) > mem_size)
	printf("MEMORY OVERFLOW IN MONITOR SHM\n");
    return ((void *) address);
}

 /*************************************************************************
 * Initialize the monitoring for NT, create a shared memory mapped file   *
 * which can be accessed using the .mon_mem label across processes        *
 * Like the regular memory mapped file for prcesses, we use the in-memory *
 * handle so it is in virtual memory rather than on disk.			      *
 **************************************************************************/
static void
nt_monitorinit(int procs)
{
    int size, monbuf_size, bufsteer_size;

    DBG2("monitor init, procs is %d, %d\n", procs,
	 config.threads_per_proc);
    monbuf_size = sizeof(MonitorBuffer) + sizeof(struct cth_mutex) +
     size_of_monitor_buffer;
    bufsteer_size = size_of_lm_steer_buffer + sizeof(MonitorBuffer) +
	sizeof(struct cth_mutex);
    size =
	page_aligned_size(sizeof(LocalMonitorInfo) * number_of_lms +
			  MAX_NUM_SENSORS +
			  procs * config.threads_per_proc * monbuf_size +
			  sizeof(unsigned long) +
			  sizeof(struct cth_mutex) +
			  MAX_NUM_SENSORS +
			  number_of_lms * bufsteer_size +
			  MAX_NUM_SAMPLING_INST *
        (2 * sizeof(unsigned long) + 3 * sizeof(void *) + sizeof(char)) +
			  getpagesize());

    size = size * 2;

    hMonitorMemory = CreateFileMapping((HANDLE) 0xFFFFFFFF, NULL, PAGE_READWRITE,
				       0, size, ".mon_mem");

    DBG1("getting shared monitor memory, size is %d\n", size);

    if (hshared_memory == NULL) {
	perror("SHared Memory GET failed, Monitor Memory!");
	CloseHandle(hMonitorMemory);
	exit(12);
    }
    mem_size = size;
    mon_base = (UCHAR *) MapViewOfFile(hMonitorMemory, FILE_MAP_READ | FILE_MAP_WRITE,
				       0, 0, 0);
    if (mon_base == NULL) {
	perror("Cannot map monitor shared memory");
	CloseHandle(hMonitorMemory);
	exit(13);
    }
    mon_offset = 0;

    monitorinit(procs);
}

/**************************************
 ** NT uses 0 to sleep function to   **
 ** force current thread (virtual    **
 ** processor) to block		     **
 **************************************/

void
relinquish_processor()
{
    Sleep(0);
}

/**************************************
 ** To exit the virtual processor    **
 ** use the NT end thread call	     **
 **************************************/
void
child_exit(status)
int status;
{
    int i;
    DBG1("in LWP child_exit %d\n", virtual_processor());
    for (i = 0; i < total_procs_forked; i++) {
        processor[i].terminate = TERMINATE;
    }
    fflush(stdout);
    fflush(stderr);
    DBG1("Doing exit thread %d\n", virtual_processor());
    total_procs_exit--;
    ExitThread(status);
}

unsigned long start_time;

/***************************************
 ** NT calls to get timestamps		  **
 ***************************************/
unsigned long
cthread_timestamp()
{
    SYSTEMTIME tp0;
    unsigned long timestamp;

    if (logicalTimeStamp) {
	internal_mutex_lock(&logicalTimeStamp_lock->mlock);
	timestamp = (*logicalTimeStamp_counter)++;
	internal_mutex_unlock(&logicalTimeStamp_lock->mlock);
    } else {
	GetSystemTime(&tp0);
	timestamp = (unsigned long) tp0.wSecond * 1000000 + tp0.wMilliseconds;
	timestamp -= start_time;
    }
    return timestamp;
}

/********************************************
 **										   **
 ********************************************/

void
get_start_timestamp_and_resolution(start_time_p, resolution_p)
unsigned long *start_time_p;
unsigned long *resolution_p;
{
    SYSTEMTIME tp0;

    if (logicalTimeStamp) {
	*resolution_p = 1;
	start_time = 0;
    } else {
	GetSystemTime(&tp0);
	*resolution_p = 1000000;
	start_time = (unsigned long) tp0.wSecond * 1000000 + tp0.wMilliseconds;
    }
    *start_time_p = start_time;
}

/***********************************************
 ** This routine checks the current running	  **
 ** thread ID against the virtual processors  **
 ** to see which one is running			      **
 ** We can't use the handles because they are **
 ** not globally unique.					  **
 ***********************************************/
int
virtual_processor()
{
    int i;
    DWORD id;

    id = GetCurrentThreadId();

    for (i = 0; i < total_procs; i++) {
	if (id == dwThreadID[i]) {
	    return i;
	}
    }
}

 /****************************************************
  ** This routine shuts down the virtual processors **
  ** after an error occurs.  Should be called only  **
  ** if error detected.								**
  ****************************************************/
void
shutdown_processes(int exitCode)
{
    int i;

    printf("Shutdown total process called for ERROR: %i\n", exitCode);

    for (i = 0; i < *num_of_procs; i++) {
	printf("Killed child %d in logical processor %d\n",
	       typed_processes[i], i);
	CloseHandle(typed_processes[i]);
    }

    /* shut down the shared memory handles */
    CloseHandle(hshared_memory);
    CloseHandle(hMonitorMemory);
    /* shut down the IO control */
    close_global_io();
    /* this exits the whole shebang */
    exit(exitCode);
}

/* NT has 4K pages */
int
getpagesize()
{
    return (4096);
}
