/* nt.c */
#include "config.h"
#include <windows.h>


#include <sys/types.h>
#include <stdio.h>

#include "assert.h"
#include "general.h"
#include "internal.h"
#include "hwlib.h"
#include "internal.h"
#include "init.h"
#include "nt_init.h"

extern CRITICAL_SECTION cs;	/* critical section used for locking */

/* defined in threads.c */
void start_thread ARGS((int (*func) (), any_t arg));
void start_threadV ARGS((int (*func) (), int n, any_t arg));
extern cthread_t current_thread_array[MAX_PROC];
extern internal_cthread_exit();

static void
exchange(locka, val, outa)
UINT *locka;
UINT val;
UINT *outa;
{
    /* xchg val,*lock */
    UINT temp;

    EnterCriticalSection(&cs);
    temp = *locka;
    *locka = val;
    val = temp;
    *outa = temp;
    LeaveCriticalSection(&cs);
}

int
TRY_TO_LOCK(l)
LOCK *l;
{
    UINT out = 0;
    exchange(l, 0x00ff, &out);
    return out;
}

/* int sp; */

void
fix_jbuf(t, func, arg)
cthread_t t;
any_t(*func) ();
long *arg;
{
    long *sp;

    if (setjmp((t->jbuf)) != 0) {
	fprintf(stderr, "FATAL ERROR: Unexpected return from setjmp in fix_jbuf");
    }
    /* init the stack so we can just do a longjmp and it will call *
     * start_thead */
    /* make the final return address point to thread exit to catch returns 
     * 
     */
    sp = (long *) t->stack_top;
    *(--sp) = (long) arg;	/* arg 2 */
    *(--sp) = (long) func;	/* arg 1 */
    *(--sp) = (long) internal_cthread_exit;

    /* init the jmp buffer */
    /* If porting to NT under DEC ALPHA or MIPS, modify these next 2 jbuf
     * * entries to *get the correct stack location. */
    (t->jbuf)[4] = (long)(--sp);/* NT has stack ptr 1 ahead so sub 1 extra 
				 * 
				 */
    (t->jbuf)[5] = (long)start_thread;

}

void
DISPATCH(thread)
cthread_t thread;
{
    if ((thread)->already_started) {
	DBG4("calling longjmp, sp is %lx , ip is %lx, thread context is %lx node is %i\n",
	     (long) (thread)->jbuf[4], (long) (thread)->jbuf[5],
	     (long) thread, virtual_processor());

	longjmp((thread->jbuf), 1);
    } else {
	fix_jbuf(thread, thread->func, (long *) thread->arg);

	DBG4("calling MY_longjmp, sp is %lx, ip is %lx,  thread context is %lx, node is %i\n",
	     (long) ((thread)->jbuf)[4], (long) ((thread)->jbuf)[5],
	     (long) thread, virtual_processor());

	(thread)->already_started = 1;

	longjmp(((thread)->jbuf), 1);
    }
}

void
swap_context_with_func(func, arg)
void (*func) ();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];

    if (setjmp(current_thread->jbuf) == 0) {
	/* 
	 * **  0 return from setjmp the first time the buffer is set. **
	 * value is non-zero when we longjmp back here */
	(func) (arg);

	/* func should never return */
	assert(FALSE);
    }
}

void *
get_sp_from_context(context_ptr)
cthread_context *context_ptr;
{
    return (context_ptr[4]);
}
