
/*** monitor_ur.h : This file contains header information about user requests.
  ***/

#ifndef __MONITOR_UR_H__
#define __MONITOR_UR_H__

#ifndef False
#define False  0
#endif
#ifndef True
#define True   1
#endif


#define OK_MESSAGE      1226
#define ERROR_MESSAGE   -1

#define UR_CONTINUE             	1
#define UR_PAUSE			10
#define UR_STOP				2
#define UR_QUIT				3
#define UR_START_ON_LINE_DISPLAY	4
#define UR_PROBE_OBJECT			5
#define UR_TURN_SENSOR_ON		8
#define UR_TURN_SENSOR_OFF 		9

/* using simple_command data structure */
#define UR_CM_QUIT			101
#define UR_APPLICATION_QUIT		102
#define UR_CM_PAUSE			103
#define UR_APPLICATION_PAUSE		104
#define UR_CM_CONTINUE			105
#define UR_APPLICATION_CONTINUE		106
#define UR_CM_DISCARD			107
#define UR_APPLICATION_DISCARD		108
#define UR_CM_STEPPING			109
#define UR_TURNON_SENSOR		110
#define UR_TURNOFF_SENSOR		111
#define UR_TURNON_ALL_SENSORS		112
#define UR_TURNOFF_ALL_SENSORS		113
#define UR_CANCEL			999

/* using named_command data structure */
#define UR_CM_CONNECT_PROCESS		201
#define UR_CM_DISCONNECT_PROCESS	202
#define UR_TURNON_NAMED_SENSOR		203
#define UR_TURNOFF_NAMED_SENSOR		204

/* steering commands: >=  0x4000 */
#define UR_STEER_START			0x4000

#define UR_STEER_SIMPLE			0x4100
#define UR_STEER_FLOAT			0x4101
#define UR_STEER_NAMED			0x4102
#define UR_STEER_TEST			0x4103


/* user can define up to USER_STEER_MAX steering actions */
#define USER_STEER_BASE			0x4000
#define USER_STEER_MAX			256


typedef struct _URSimpleCommand {
    short       type;
    short       proc;
    short       sensor;
    int     int_field;
    int     aux_int;
} URSimpleCommand, *URSimpleCommandPtr;

typedef struct _URFloatCommand {
    short       type;
    short       proc;
    short       sensor;
    double  float_field;
    double  aux_float;
} URFloatCommand, *URFloatCommandPtr;

typedef struct _URNamedCommand {
    short       type;
    short       proc;
    short       sensor;
    char    *file_name;
    char    *aux_name;
} URNamedCommand, *URNamedCommandPtr;

typedef union _URAnyCommand {
    URSimpleCommand  simple_cmd;
    URFloatCommand   float_cmd;
    URNamedCommand   named_cmd;
} URAnyCommand, *URAnyCommandPtr;


typedef struct _ProbeData {
    short       type;
    short       proc;
    short       sensor;
    long	int_data;
    double	float_data;
    char	*str_data;
} ProbeData, *ProbeDataPtr;


typedef enum _LMStateType {
    LM_NONE, LM_RUN, LM_QUIT, LM_PAUSE, LM_DISCARD
} LMStateType, *LMStateTypePtr;

extern shared LMStateType	loc_mon_state;
extern int
ReadProcessURCommand ARGS((LocalMonitorInfoPtr lm, LMStateTypePtr lm_state_ptr));

#endif
