/*  File lm.c
 *
 *  This file contains the source code for the local monitor process
 *  running with the cthreads package
 *
 */
#include "config.h"
#include <sys/types.h>
#include <stdio.h>
/*#include "IDLtoC.h"*/

#include	"general.h"
#include	"arch_init.h"
#include	"internal.h"

#include        "monitor.h"
#include	"monitor_ur.h"
#include	"mon_globals.h"
#include	"mon.sensorextern.h"

extern shared  struct  local_info  *processor;

extern void cthread_perror ARGS((char *msg, RESULT err));
extern void child_exit ARGS((int));
extern void internal_cthread_yield();
extern void internal_cthread_exit ARGS((any_t res));

/* random Unix externals */
extern void perror();
extern int fclose();
extern void *malloc();
extern char *strcat();
extern int poll();
extern void free ARGS((void *ptr));

extern void relinquish_processor();

#define MBUFFER_NOT_READ	0    /* monitor buffers not read yet */
#define MBUFFER_DIRTY		1    /* there's something in monitor buffers */
#define MBUFFER_CLEAN_1		2    /* nothing in buffer last pass */
#define MBUFFER_CLEAN_2		3    /* nothing in buffer last passes */


static int
generic_steer_handler(de, dep, format_id, record, record_length, function)
DExchange de;
DEPort dep;
int format_id;
void *record;
int record_length;
CommandHandlerProc function;
{
    DBG1("In Generic steering handler, for format %s\n",
	DEget_format_name(de, format_id));

    function(record);
    return 0;
}

void* mon_obj_creation_attr_list = NULL;

static void
mon_handle_event(lm, buf, size)
LocalMonitorInfoPtr lm;
char *buf;
unsigned int size;
{
    int type = ((SimpleTraceDataRecordPtr) &buf[0])->type;

    if (lm->ioevent_format_ids[type] == -1) {
	lm_check_sensor_list(lm);
    }
    if (monitor_action_list[type]) {
	monitor_action_list[type](buf);
    }
    
    if (monitor_output == SOCKET_OUTPUT ||
	monitor_output == BINARY_FILE_OUTPUT) {
	DBG1("Handle event type \"%s\"\n", monitor_get_sensor_name(type));
	DExchange_forward_data(lm->de, NULL, 
			       lm->ioevent_format_ids[type],
			       buf);
    }
    if (steering_enabled) {
	InsertBuffer(&lm_to_steer_bufs[lm->lm_num], buf, size);
    }
#if 0
    if (adv_steer_enabled) {	/* not reg steering */
	printf("advsteering item inserted into monID=%d\n",
	       lm->lm_num);
	InsertBuffer(&lm_to_steer_bufs[lm->lm_num], buf, size);
    }
#endif
}

extern cthread_t current_thread_array[MAX_PROC];
extern shared int *num_of_procs;
extern unsigned long  cthread_ts_resolution;

int
monitor_process(lm_node)
int lm_node;
{
    char             *buf = malloc(size_of_monitor_buffer);
    SimpleTraceDataRecordPtr  simpleTrace = (SimpleTraceDataRecordPtr) &buf[0];
    MonitorBufferPtr ptr;
    unsigned int     size;
    short            c=0, repeatN;
    short	     mbuffer_state = MBUFFER_NOT_READ;
    int 	     current_lm = lm_node;
    LocalMonitorInfoPtr  lm = lm_info[current_lm];
    int 	     proc = virtual_processor();

    cthread_t 	     this_thread = current_thread_array[virtual_processor()];
    MonitorBufferPtr my_buffer = GetMonitorBufferPtr(this_thread);

    DBG2("Local monitor started on node %d, proc %d\n", lm_node, proc);
    init_lm_output_conn (lm);
    DBG("LM: sending initial events\n");
    DM_Sensor_thread_init("initial processor", *num_of_procs, number_of_lms, 0,
			  cthread_ts_resolution);
    if (RetrieveBuffer(my_buffer, buf, &size) && (size > 0)) {
	/* fixup initial event */
	simpleTrace->timestamp = 0;
	simpleTrace->thread = 0;
	mon_handle_event(lm, buf, size);
    }
    /* if LM#0, fake a thread_fork event for the initial thread */
    if (lm->lm_num == 0) {
	DM_Sensor_thread_fork("Initial Thread", *initial_thread, 0, 0);
	if (RetrieveBuffer(my_buffer, buf, &size) && (size > 0)) {
	    /* fixup faked fork */
	    simpleTrace->timestamp = 1;
	    simpleTrace->thread = 0;
	    mon_handle_event(lm, buf, size);
	}
    }

    DBG("before_cobs_init\n");
/*    _COBS_otl_init("mon");
    DBG("after_cobs_init\n");
    
    mon_obj_creation_attr_list = create_attr_list();
    add_attr((attr_list) mon_obj_creation_attr_list, 
	     attr_atom_from_string("COBS:OTL_OBJECT"), 
	     Attr_Int4, (attr_value) 1);
	     */
    if (*monitor_status == (short) MONITOR_NOT_INITIALIZED) {
	*monitor_status = (short) MONITOR_RUNNING;
    }
    while (*monitor_status != MONITOR_FINISHED) {

	/* any commands from probing socket ? */
	if (lm->default_forward && lm->de != NULL) {
	    int i;
	    DExchange_poll_and_handle(lm->de, 0 /* don't block*/);
	    if (loc_mon_state == LM_QUIT) {
		fprintf(stderr, "lm: Got user command to quit program\n");
		/* goto finish; */
		if( monitor_output ==  SOCKET_OUTPUT)
		  end_socket_connection(lm, FALSE); /* no abort */ 
		monitor_output = NO_OUTPUT;
		monitoring_enabled = FALSE;
		internal_cthread_exit((any_t)0);
	    }
	    for (i = 0; i < USER_STEER_MAX; i++) {
		if ((command_handlers_list[i].fmt_name != NULL) &&
		    (command_handlers_list[i].registered == 0)) {
		    CommandHandlersInfoPtr elem = &command_handlers_list[i];
		    DExchange_register_format(lm->de, elem->fmt_name, 
					      elem->field_list);
		    DExchange_register_function(lm->de, elem->fmt_name,
						 (DataHandlingFunc)generic_steer_handler,
						 (void*)elem->data_handler);
		    DEport_set_format_block(lm->dep, elem->fmt_name, FALSE);
		    command_handlers_list[i].registered = 1;
		}
	    }
	}

	internal_mutex_lock(&lm_info_lock->mlock);
/*	DBG("LM: Beginning per-buffer while\n");*/
	/* let's go through all threads being monitored for getting 
	   information: */
	ptr =  lm->buffer_list;
	internal_mutex_unlock(&lm_info_lock->mlock);
	while (ptr != NULL) {
            c = 0;
	    repeatN = 10;
	    while (repeatN > 0) {
		if (RetrieveBuffer(ptr, (char*) buf, (unsigned int*) &size)) {
		    if (size > 0) {
			mbuffer_state = MBUFFER_DIRTY;
			mon_handle_event(lm, buf, size);
		    }
		    repeatN--;
		} 
		else repeatN = 0;
	    }
	    /* go to next monitored thread */
	    ptr = ptr->next;
	}
	/* check sampling sensors, lm #0 as sampling sensor server */
	if (current_lm == 0) {
	    int  i;
	    unsigned long  current_ts = cthread_timestamp();
	    for (i = 0; i < (*sampling_sensor_num); i++) {
		if (sampling_sensor_switch[i] &&
		    (current_ts - sampling_sensor_last_ts[i] >
		     sampling_sensor_interval[i])) {
		    sampling_sensor_list[i](i, buf);
		    simpleTrace->timestamp = current_ts;
		    if (monitor_output == SOCKET_OUTPUT ||
			monitor_output == BINARY_FILE_OUTPUT) {
			DBG("Handle event\n");
			DExchange_forward_data(lm->de, NULL, 
					       lm->ioevent_format_ids[simpleTrace->type],
					       buf);
		    }
		}
	    }
	}
	if (mbuffer_state==MBUFFER_DIRTY || mbuffer_state==MBUFFER_NOT_READ)
	  mbuffer_state = MBUFFER_CLEAN_1;
	else if (mbuffer_state == MBUFFER_CLEAN_1)
	  mbuffer_state = MBUFFER_CLEAN_2;
	else {
	    if (*monitor_status == (short) MONITOR_SHOULD_EXIT ||
		processor[proc].terminate == TERMINATE) {
		*monitor_status = (short) MONITOR_FINISHED;
	    }
	    else mbuffer_state = MBUFFER_CLEAN_1;
	}
	/*** The relinquish_processor() significantly slows down local monitor
	  ** on KSR implementation, but it is necessary for
	  ** single physical processor versions.   We need to find
	  ** a better solution for KSR version.
	  ** Weiming.  3/21/94.
	  ***/
	internal_cthread_yield();
	relinquish_processor();
    }
    
/*  finish: */
    DBG("End of monitor_process\n");

    DM_Sensor_monitor_exit(current_lm);

    if (monitor_output == SOCKET_OUTPUT ||
	monitor_output == BINARY_FILE_OUTPUT) {
	/* check own buffer once more to get the monitor_exit event */
	if (RetrieveBuffer(my_buffer, buf, &size) && (size > 0)) {
	    mon_handle_event(lm, buf, size);
	}
    }

    if (monitor_output == BINARY_FILE_OUTPUT) {
           DEport_close(lm->dep);
    }

    if (monitor_output == SOCKET_OUTPUT)
                 end_socket_connection(lm, FALSE); /* no abort */ 
    child_exit(0); /* child */
    /*NOTREACHED*/
    return 0;
} /* end of monitor_process */


