#ifndef MONITOR_BUFFER_H
#define MONITOR_BUFFER_H
/*
typedef struct _MonitorData {
    short          type;
    short          nodenum;
    unsigned long  timestamp;
} MonitorData, *MonitorDataPtr;
*/ 

typedef struct _MonitorBuffer {
    mutex_t lock;            /* lock for accessing this buffer */
    char    *rdPtr, *wrPtr;  /* read and write pointer of the buffer */
    int     bufSize;         /* size of the buffer */
    int     bufLeft;         /* buffer left for use */
    char    *buffer;         /* buffer */
    struct _MonitorBuffer *next; /* next buffer */
} MonitorBuffer, *MonitorBufferPtr;

MonitorBufferPtr
  InitBuffer ARGS((int size,
		   int node));


MonitorBufferPtr
   InitMultiBuffer ARGS((int  num,
			 int  size,
			 int  node));

int
  InsertBuffer ARGS((MonitorBufferPtr bufPtr,
		     char *item,
		     unsigned int  size));

int
  RetrieveBuffer ARGS((MonitorBufferPtr bufPtr,
		       char *item,
		       unsigned int* sizePtr));
 
struct cthread;  /* forward declaration */

MonitorBufferPtr
  GetMonitorBufferPtr ARGS((struct cthread *thread_id));

#endif






