/*monitor_buffer.c
  */
#include "assert.h"
#include "memory.h"
#include "string.h"
#include <stdio.h>
#include <sys/types.h>

#include        "results.h"
#include        "general.h"
#include        "lock.h"
#include        "queue.h"
#include        "sync.h"
#include        "internal.h"
#include	"memalloc.h"
#include "monitor.h"
#include "threads.h"
#include "arch_init.h"

extern void cthread_perror ARGS((char *msg, RESULT res));
extern void *allocate_monmem ARGS((int size, int node));

extern cthread_t current_thread_array[MAX_PROC];
extern mutex_t print_lock;

extern char		variant_event_flag[MAX_NUM_SENSORS];
extern IOField     	*arrayof_event_flds[MAX_NUM_SENSORS];

MonitorBufferPtr
InitBuffer(size, node)
int size, node;
{
    MonitorBufferPtr  buf;

    if (size % 8) size = (size / 8 + 1) * 8;
    /*** allocate buffer in shared memory ***/
    buf = (MonitorBufferPtr)allocate_monmem(sizeof(MonitorBuffer), node);
    buf->lock = (mutex_t)allocate_monmem(sizeof(struct cth_mutex), node);
    LOCK_INIT((buf->lock)->mlock);
    buf->buffer = (char *)allocate_monmem(size, node);

    buf->rdPtr = buf->wrPtr = buf->buffer;
    buf->bufSize = buf->bufLeft = size;
    buf->next = NULL;
    return buf;
}


MonitorBufferPtr InitMultiBuffer(num, size, node)
int num, size, node;
{
    MonitorBufferPtr  bufs;
    int  i;

    if (size % 8) size = (size / 8 + 1) * 8;
    /*** allocate multiple buffers in shared memory ***/
    bufs = (MonitorBufferPtr)allocate_monmem(sizeof(MonitorBuffer)*num, node);
    for (i = 0; i < num; i++) {
	bufs[i].lock = (mutex_t)allocate_monmem(sizeof(struct cth_mutex), node);
	LOCK_INIT((bufs[i].lock)->mlock);
	bufs[i].buffer = (char *)allocate_monmem(size, node);
	
	bufs[i].rdPtr = bufs[i].wrPtr = bufs[i].buffer;
	bufs[i].bufSize = bufs[i].bufLeft = size;
    }

    return bufs;
}


int
  InsertBuffer(bufPtr, item, event_size)
MonitorBufferPtr bufPtr;
char *item;
unsigned int  event_size;
{
    int  i, total_size;
    int  variant_size = 0;
    int  type = ((SimpleTraceDataRecordPtr) item)->type;
    IOField *flds = NULL;
    if (type < 0 || type >= MAX_NUM_SENSORS ||
	arrayof_event_flds[type] == NULL) {
	fprintf(stderr, "cthreads monitor: Unknown type of sensor (%d) sent to buffer\n",
		type);
	return -1;
    }
    flds = arrayof_event_flds[type];
    if (bufPtr  == NULL) {
	bufPtr = GetMonitorBufferPtr(current_thread_array[virtual_processor()]);
    }
    if (variant_event_flag[type]) {
	for (i = 0; flds[i].field_name != NULL; i++) {
	    if (!strcmp(flds[i].field_type, "string")) {
		char** str_ptr = (char**) (item + flds[i].field_offset);
		if (*str_ptr == NULL) variant_size++;
		else variant_size += strlen(*str_ptr) + 1;
	    }
	}
    }
    total_size = event_size + variant_size;
    if (total_size % 2) total_size++;
    SPIN_LOCK(&bufPtr->lock->mlock);
    if (bufPtr->bufLeft < total_size + 2) {
	SPIN_UNLOCK(&bufPtr->lock->mlock);
	if (bufPtr->bufSize < total_size + 2) {
	    return -1;
	} else {
	    return 0;
	}
    } else {
	char *start_event_ptr;
	if (bufPtr->wrPtr + 1 >= bufPtr->buffer+bufPtr->bufSize) {
	    bufPtr->wrPtr = bufPtr->buffer;
	}
	*(bufPtr->wrPtr++) = total_size >> 8;
	*(bufPtr->wrPtr++) = total_size;
	start_event_ptr = bufPtr->wrPtr;
	i = bufPtr->bufSize - (bufPtr->wrPtr - bufPtr->buffer);
	if (i > (int) event_size) {
	    memcpy(bufPtr->wrPtr, item, event_size);
	    bufPtr->wrPtr += event_size;
	} else {
	    memcpy(bufPtr->wrPtr, item, i);
	    memcpy(bufPtr->buffer, item+i, event_size - i);
	    bufPtr->wrPtr = bufPtr->buffer + event_size - i;
	}

	if (variant_event_flag[type]) {
	    char *offset_ptr = (char*) event_size;
	    for (i = 0; flds[i].field_name != NULL; i++) {
		if (!strcmp(arrayof_event_flds[type][i].field_type,"string")) {
		    char** str_ptr = (char**) (item + flds[i].field_offset);
		    char* p = start_event_ptr + flds[i].field_offset;
		    int   n, len;
		    /* write offset in the string pointer field */
		    if (p >= bufPtr->buffer+bufPtr->bufSize)
			p= p-bufPtr->bufSize;
		    n = bufPtr->bufSize - (p - bufPtr->buffer);
		    if (sizeof(char*) <= n) {
			memcpy(p, &offset_ptr, sizeof(char*));
		    } else {
			memcpy(p, &offset_ptr, n);
			memcpy(bufPtr->buffer, ((char*) &offset_ptr) + n,
			       sizeof(char*) - n);
		    }
		    /* copy strings to buffer */
		    if (*str_ptr == NULL) len = 0;
		    else len = strlen(*str_ptr);
		    if (len >= variant_size - 1) len = variant_size - 1;
		    if (len > 0) {
			n = bufPtr->bufSize - (bufPtr->wrPtr - bufPtr->buffer);
			if (len <= n) {
			    memcpy(bufPtr->wrPtr, *str_ptr, len);
			    bufPtr->wrPtr += len;
			} else {
			    memcpy(bufPtr->wrPtr, *str_ptr, n);
			    memcpy(bufPtr->buffer, (*str_ptr) + n, len - n);
			    bufPtr->wrPtr = bufPtr->buffer+len-n;
			}
		    }
		    if (bufPtr->wrPtr >= bufPtr->buffer + bufPtr->bufSize)
			bufPtr->wrPtr = bufPtr->buffer;
		    *(bufPtr->wrPtr++) = '\0';
		    variant_size -= (len + 1);
		    offset_ptr = offset_ptr + len + 1;
		    if (variant_size <= 0) {
			variant_size = 1;
			offset_ptr = (char*) total_size - 1;
			bufPtr->wrPtr = start_event_ptr + total_size - 1;
			if (bufPtr->wrPtr - bufPtr->buffer >= bufPtr->bufSize)
			    bufPtr->wrPtr = bufPtr->wrPtr - bufPtr->bufSize;
		    }
		}
	    }
	    /* set write pointer */
	    bufPtr->wrPtr = start_event_ptr + total_size;
	    if (bufPtr->wrPtr - bufPtr->buffer >= bufPtr->bufSize)
		bufPtr->wrPtr = bufPtr->wrPtr - bufPtr->bufSize;
	}
	bufPtr->bufLeft -= (total_size + 2);
	SPIN_UNLOCK(&bufPtr->lock->mlock);
	return 1;
    }
}

int
RetrieveBuffer(bufPtr, item, sizePtr)
MonitorBufferPtr bufPtr;
char *item;
unsigned int* sizePtr;
{
    int i, n, type;
    unsigned int total_size;

    SPIN_LOCK(&bufPtr->lock->mlock);
    if (bufPtr->bufLeft >= bufPtr->bufSize) {
	SPIN_UNLOCK(&bufPtr->lock->mlock);
	return 0;

    } else {
	if (bufPtr->rdPtr + 1 >= bufPtr->buffer+bufPtr->bufSize) {
	    bufPtr->rdPtr = bufPtr->buffer;
	}
	total_size = (unsigned char) *(bufPtr->rdPtr++);
	total_size = (total_size << 8) + ((unsigned char) *(bufPtr->rdPtr++));
	n = bufPtr->bufSize - (bufPtr->rdPtr - bufPtr->buffer);
	if (n > (int) total_size) {
	    memcpy(item, bufPtr->rdPtr, total_size);
	    bufPtr->rdPtr += total_size;
	} else {
	    memcpy(item, bufPtr->rdPtr, n);
	    memcpy(item+n, bufPtr->buffer, total_size - n);
	    bufPtr->rdPtr = bufPtr->buffer+total_size-n;
	}
	bufPtr->bufLeft += (total_size + 2);
	SPIN_UNLOCK(&bufPtr->lock->mlock);
	type = ((SimpleTraceDataRecordPtr) item)->type;
	if (variant_event_flag[type]) {
	    IOField *flds = arrayof_event_flds[type];
	    item[total_size] = '\0';
	    for (i = 0; flds[i].field_name != NULL; i++) {
		if (!strcmp(flds[i].field_type, "string")) {
		    char** str_ptr = (char**) (item + flds[i].field_offset);
		    *str_ptr = item + (unsigned int) (*str_ptr);
		}
	    }
	    total_size++;
	}
	*sizePtr = total_size;
	return total_size;
    }
}

