/* monitor.h
 */

#ifndef __MONITOR_H__
#define __MONITOR_H__

/* INCLUDE FILES THAT INCLUDE OTHER INCLUDE FILES SUCK */


#include "monitor_buf.h"
#include "io.h"
#include "DE.h"
#include "memalloc.h"

#define  DEFAULT_NUM_PROCS_PER_LM  8
#define  MAX_NUMBER_OF_LMS	8
#define  SIMPLE_HASH_VALUE	109
#define  SimpleHash(name) \
((name[0]*256 + name[1]) % SIMPLE_HASH_VALUE)

#define MAX_NUM_SENSORS         255
#define MAX_NUM_DEFAULT_SENSORS 128
#define MAX_NUM_SAMPLING_INST	32

/* Type for action procedures and sampling sensors */

typedef int (*ActionProc) ARGS((char *));
typedef int (*SamplingSensorProc) ARGS((int, void*));
typedef int (*FormatHandlerProc) ARGS((void*));
typedef int (*CommandHandlerProc) ARGS((void*));

/* Type for monitor status */

typedef enum {
    MONITOR_NOT_INITIALIZED,
    MONITOR_RUNNING,
    MONITOR_SHOULD_EXIT,
    MONITOR_FINISHED
} MonitorStatus, *MonitorStatusPtr;


#define FORWARD_ALL		1  /* send everything to me */
#define FORWARD_SELECTED	2  /* send only those I choose */
#define IGNORE_SELECTED		3  /* ignore only those I choose */
#define IGNORE_ALL		4  /* don't send anything to me */


/* Type LocalMonitorInfo */
typedef struct _LocalMonitorInfo {
    MonitorBufferPtr buffer_list;
    int              lm_num;		/* my LM number */
    int              monitor_load;
    int		     ioevent_format_ids[MAX_NUM_SENSORS];
    int              default_forward;	/* wether forward commands to me */
    DExchange	     de;
    DEPort   	     dep;
    IOFormat	     signon_fmt, signoff_fmt, shutdown_fmt; /* outgoing fmt */
    IOFormat	     simplecom_fmt, floatcom_fmt, namedcom_fmt; /* incoming */
} LocalMonitorInfo, *LocalMonitorInfoPtr;

/* Type SteerServerInfo */
typedef struct _SteerServerInfo {
    int              server_num;	/* my LM number */
    int              default_forward;	/* wether forward commands to me */
    DExchange	     de;
    DEPort   	     dep;
    IOFormat	     simplecom_fmt, floatcom_fmt, namedcom_fmt; /* incoming */
} SteerServerInfo, *SteerServerInfoPtr;


typedef enum {
    NO_OUTPUT,            /* no output from monitor */
    BINARY_FILE_OUTPUT,   /* output from monitor into a binary file */
    SOCKET_OUTPUT         /* output from monitor to socket */
} monitor_output_t;

/* data structure for steering command handlers */
typedef struct _CommandHandlersInfo {
    char		*fmt_name;	/* format name */
    IOFieldList		field_list;
    int 		registered;
    CommandHandlerProc	data_handler;	/* handler for a command record */
} CommandHandlersInfo, *CommandHandlersInfoPtr;

/* This is the header for each sensor information */
typedef struct _SimpleTraceDataRecord {
    int            type;
    int		   perturbation;
    int		   distnodeID;
    unsigned long  timestamp;
    unsigned long  thread;
} SimpleTraceDataRecord, *SimpleTraceDataRecordPtr;

/* External variables */
extern shared LocalMonitorInfoPtr  lm_info[MAX_NUMBER_OF_LMS];
extern shared mutex_t         	lm_info_lock;
extern shared SteerServerInfoPtr   steer_info;
extern shared char              *cm_machine_name;
extern shared int               cm_port_number;
extern shared char		*app_list_default;
extern shared char		*type_list_default;
extern shared char              *trace_file_name;
extern shared int		number_of_lms;
extern shared int		size_of_monitor_buffer;
extern shared int		size_of_lm_steer_buffer;
extern shared int		monitoring_enabled;
extern shared int		default_monitoring_enabled;

extern shared int		distrib_monitoring_enabled;
extern shared int		dist_node_ID;

extern shared int		steering_enabled;
extern shared int		adv_steer_enabled;

extern shared monitor_output_t	monitor_output;
extern shared int               logicalTimeStamp;
extern shared mutex_t           logicalTimeStamp_lock;
extern shared unsigned long     *logicalTimeStamp_counter;

extern shared short		*monitor_status;
extern shared char		*steer_sensor_switch;
extern ActionProc		*monitor_action_list;
extern ActionProc		*user_steer_handler_list;
extern shared CommandHandlersInfo *command_handlers_list;
extern shared MonitorBufferPtr	lm_to_steer_bufs;

extern shared IOFile		steer_infile, steer_outfile;
extern shared IOFormat		steer_simplecom_fmt, steer_floatcom_fmt,
				steer_namedcom_fmt;
extern shared IOConversionPtr 	steer_simplecom_conv, steer_floatcom_conv,
				steer_namedcom_conv;
extern shared IOFormat		steer_resp_fmt;
extern shared mutex_t		sampling_sensor_lock;
extern shared SamplingSensorProc   *sampling_sensor_list;
extern shared int		*sampling_sensor_num;
extern shared char		*sampling_sensor_switch;
extern shared unsigned long   	*sampling_sensor_last_ts;
extern shared unsigned long   	*sampling_sensor_interval;

extern  void get_start_timestamp_and_resolution ARGS((unsigned long *time_p, unsigned long *resol_p));
extern  unsigned long cthread_timestamp();

extern void
CheckMonitoringSettings ARGS((char *machineName, int port_number,
			      char *monFileName, monitor_output_t *monOutFmt,
			      char *app_name));
extern unsigned long cthread_timestamp();
extern int start_socket_connection ARGS((DExchange*, DEPort*));
extern void end_socket_connection ARGS((LocalMonitorInfoPtr, int));
extern void init_lm_output_conn ARGS((LocalMonitorInfoPtr));
extern void init_steer_output_conn ARGS((SteerServerInfoPtr));

extern int get_command_handler_index ARGS((char*));
extern void *monitor_init_thread ARGS((void *tcb, void *mon_info));
extern void monitor_delete_mutex ARGS((void *mutex, void *mon_info));
extern void monitor_delete_condition ARGS((void *condition, void *mon_info));
extern int monitor_get_sensor_type_value ARGS((char *name));
extern void lm_check_sensor_list ARGS((LocalMonitorInfoPtr lm));
extern char* monitor_get_sensor_name ARGS((int type_value));
#endif 
