/***
  ** This file is generated by sensor compiler.
  ** It contains sensor code to be inserted into the monitored
  ** program.
  ***/


#include "mon.sensors.h"


/*** global variables ***/
extern int (*sensor_non_blocking_submit_event)(/* buffer, size */);
extern void (*sensor_turn_on_sampling_sensor)(/* ss_num */);
extern int (*sensor_register_sampling_sensor)(/* interval, sample_proc */);
extern int (*sensor_test_switch)(/*ss_num */);
extern void (*sensor_init_header)(/*buffer, ss_num */);
extern void (*sensor_update_header)(/*buffer*/);
extern char *(*sensor_memory_alloc)(/*size*/);
extern void *sensor_transport_info; /* transport specific info */
extern int sensor_header_size; /* transport specific header size */
extern void** sensor_listof_ss_whole_fields;
extern void** sensor_listof_ss_sampled_fields;
extern char *malloc(/*size*/);


#define IOOffset(p_type,field) \
((int) (((char *) (&(((p_type)NULL)->field))) - ((char *) NULL)))
#if defined(__STDC__) || defined(__ANSI_CPP__)
#define IOstr(s) #s
#else
#define IOstr(s) "s"
#endif
#define IOArrayDecl(type, size) IOstr(type[size])
#define IOArrayDecl2(type, size, size2) IOstr(type[size][size2]])

#ifndef NULL
#define NULL 0
#endif

typedef struct _IOField {
    char	*field_name;
    char        *field_type;
    int	        field_size;
    int         field_offset;
} IOField, *IOFieldList;

typedef struct {
    int struct_version;
    int sensor_initialized;
    int sensor_enabled;
    char *sensor_name;
    IOFieldList sensor_field_list;
    int sensor_type_value;
} sensor_descriptor;

/*** sensor thread_init ***/
static IOField _Event_Format_sensor_thread_init_[] = {
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_thread_initPtr, name)},
    {"num_processors", "integer", sizeof(int),
        IOOffset(Sensor_Type_thread_initPtr, num_processors)},
    {"num_lms", "integer", sizeof(int),
        IOOffset(Sensor_Type_thread_initPtr, num_lms)},
    {"on_processor", "integer", sizeof(int),
        IOOffset(Sensor_Type_thread_initPtr, on_processor)},
    {"timestamp_resolution", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_initPtr, timestamp_resolution)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_init = 
    {1, 0, 0, "thread_init", _Event_Format_sensor_thread_init_};
int
DM_Sensor_thread_init(name, num_processors, num_lms, on_processor, timestamp_resolution)
char*          name;
int            num_processors;
int            num_lms;
int            on_processor;
unsigned long  timestamp_resolution;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_init)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_init);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_initPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_init);
        theSpecificSensor = (Sensor_Type_thread_initPtr)(aSensor + sensor_header_size);
        theSpecificSensor->name = name;
        theSpecificSensor->num_processors = num_processors;
        theSpecificSensor->num_lms = num_lms;
        theSpecificSensor->on_processor = on_processor;
        theSpecificSensor->timestamp_resolution = timestamp_resolution;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_init, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_init);
        }
    }
    return 0;
}

/*** sensor thread_fork ***/
static IOField _Event_Format_sensor_thread_fork_[] = {
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_thread_forkPtr, name)},
    {"child_thread", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_forkPtr, child_thread)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_thread_forkPtr, sequence_number)},
    {"on_processor", "integer", sizeof(int),
        IOOffset(Sensor_Type_thread_forkPtr, on_processor)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_fork = 
    {1, 0, 0, "thread_fork", _Event_Format_sensor_thread_fork_};
int
DM_Sensor_thread_fork(name, child_thread, sequence_number, on_processor)
char*          name;
unsigned long  child_thread;
int            sequence_number;
int            on_processor;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_fork)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_fork);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_forkPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_fork);
        theSpecificSensor = (Sensor_Type_thread_forkPtr)(aSensor + sensor_header_size);
        theSpecificSensor->name = name;
        theSpecificSensor->child_thread = child_thread;
        theSpecificSensor->sequence_number = sequence_number;
        theSpecificSensor->on_processor = on_processor;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_fork, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_fork);
        }
    }
    return 0;
}

/*** sensor thread_exit ***/
static IOField _Event_Format_sensor_thread_exit_[] = {
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_exit = 
    {1, 0, 0, "thread_exit", _Event_Format_sensor_thread_exit_};
int
DM_Sensor_thread_exit()
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_exit)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_exit);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_exitPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_exit);
        theSpecificSensor = (Sensor_Type_thread_exitPtr)(aSensor + sensor_header_size);

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_exit, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_exit);
        }
    }
    return 0;
}

/*** sensor thread_begin_join ***/
static IOField _Event_Format_sensor_thread_begin_join_[] = {
    {"join_to", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_begin_joinPtr, join_to)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_begin_join = 
    {1, 0, 0, "thread_begin_join", _Event_Format_sensor_thread_begin_join_};
int
DM_Sensor_thread_begin_join(join_to)
unsigned long  join_to;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_begin_join)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_begin_join);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_begin_joinPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_begin_join);
        theSpecificSensor = (Sensor_Type_thread_begin_joinPtr)(aSensor + sensor_header_size);
        theSpecificSensor->join_to = join_to;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_begin_join, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_begin_join);
        }
    }
    return 0;
}

/*** sensor thread_end_join ***/
static IOField _Event_Format_sensor_thread_end_join_[] = {
    {"join_to", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_end_joinPtr, join_to)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_end_join = 
    {1, 0, 0, "thread_end_join", _Event_Format_sensor_thread_end_join_};
int
DM_Sensor_thread_end_join(join_to)
unsigned long  join_to;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_end_join)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_end_join);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_end_joinPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_end_join);
        theSpecificSensor = (Sensor_Type_thread_end_joinPtr)(aSensor + sensor_header_size);
        theSpecificSensor->join_to = join_to;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_end_join, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_end_join);
        }
    }
    return 0;
}

/*** sensor thread_detach ***/
static IOField _Event_Format_sensor_thread_detach_[] = {
    {"detach_from", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_detachPtr, detach_from)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_detach = 
    {1, 0, 0, "thread_detach", _Event_Format_sensor_thread_detach_};
int
DM_Sensor_thread_detach(detach_from)
unsigned long  detach_from;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_detach)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_detach);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_detachPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_detach);
        theSpecificSensor = (Sensor_Type_thread_detachPtr)(aSensor + sensor_header_size);
        theSpecificSensor->detach_from = detach_from;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_detach, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_detach);
        }
    }
    return 0;
}

/*** sensor thread_yield ***/
static IOField _Event_Format_sensor_thread_yield_[] = {
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_yield = 
    {1, 0, 0, "thread_yield", _Event_Format_sensor_thread_yield_};
int
DM_Sensor_thread_yield()
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_yield)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_yield);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_yieldPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_yield);
        theSpecificSensor = (Sensor_Type_thread_yieldPtr)(aSensor + sensor_header_size);

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_yield, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_yield);
        }
    }
    return 0;
}

/*** sensor thread_set_name ***/
static IOField _Event_Format_sensor_thread_set_name_[] = {
    {"the_thread", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_set_namePtr, the_thread)},
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_thread_set_namePtr, name)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_set_name = 
    {1, 0, 0, "thread_set_name", _Event_Format_sensor_thread_set_name_};
int
DM_Sensor_thread_set_name(the_thread, name)
unsigned long  the_thread;
char*          name;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_set_name)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_set_name);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_set_namePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_set_name);
        theSpecificSensor = (Sensor_Type_thread_set_namePtr)(aSensor + sensor_header_size);
        theSpecificSensor->the_thread = the_thread;
        theSpecificSensor->name = name;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_set_name, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_set_name);
        }
    }
    return 0;
}

/*** sensor mutex_begin_lock ***/
static IOField _Event_Format_sensor_mutex_begin_lock_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_begin_lockPtr, mutex)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_mutex_begin_lockPtr, sequence_number)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_begin_lock = 
    {1, 0, 0, "mutex_begin_lock", _Event_Format_sensor_mutex_begin_lock_};
int
DM_Sensor_mutex_begin_lock(mutex, sequence_number)
unsigned long  mutex;
int            sequence_number;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_begin_lock)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_begin_lock);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_begin_lockPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_begin_lock);
        theSpecificSensor = (Sensor_Type_mutex_begin_lockPtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;
        theSpecificSensor->sequence_number = sequence_number;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_begin_lock, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_begin_lock);
        }
    }
    return 0;
}

/*** sensor mutex_end_lock ***/
static IOField _Event_Format_sensor_mutex_end_lock_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_end_lockPtr, mutex)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_mutex_end_lockPtr, sequence_number)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_end_lock = 
    {1, 0, 0, "mutex_end_lock", _Event_Format_sensor_mutex_end_lock_};
int
DM_Sensor_mutex_end_lock(mutex, sequence_number)
unsigned long  mutex;
int            sequence_number;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_end_lock)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_end_lock);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_end_lockPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_end_lock);
        theSpecificSensor = (Sensor_Type_mutex_end_lockPtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;
        theSpecificSensor->sequence_number = sequence_number;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_end_lock, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_end_lock);
        }
    }
    return 0;
}

/*** sensor mutex_unlock ***/
static IOField _Event_Format_sensor_mutex_unlock_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_unlockPtr, mutex)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_mutex_unlockPtr, sequence_number)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_unlock = 
    {1, 0, 0, "mutex_unlock", _Event_Format_sensor_mutex_unlock_};
int
DM_Sensor_mutex_unlock(mutex, sequence_number)
unsigned long  mutex;
int            sequence_number;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_unlock)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_unlock);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_unlockPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_unlock);
        theSpecificSensor = (Sensor_Type_mutex_unlockPtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;
        theSpecificSensor->sequence_number = sequence_number;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_unlock, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_unlock);
        }
    }
    return 0;
}

/*** sensor mutex_alloc ***/
static IOField _Event_Format_sensor_mutex_alloc_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_allocPtr, mutex)},
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_mutex_allocPtr, name)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_alloc = 
    {1, 0, 0, "mutex_alloc", _Event_Format_sensor_mutex_alloc_};
int
DM_Sensor_mutex_alloc(mutex, name)
unsigned long  mutex;
char*          name;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_alloc)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_alloc);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_allocPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_alloc);
        theSpecificSensor = (Sensor_Type_mutex_allocPtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;
        theSpecificSensor->name = name;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_alloc, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_alloc);
        }
    }
    return 0;
}

/*** sensor mutex_init ***/
static IOField _Event_Format_sensor_mutex_init_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_initPtr, mutex)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_init = 
    {1, 0, 0, "mutex_init", _Event_Format_sensor_mutex_init_};
int
DM_Sensor_mutex_init(mutex)
unsigned long  mutex;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_init)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_init);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_initPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_init);
        theSpecificSensor = (Sensor_Type_mutex_initPtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_init, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_init);
        }
    }
    return 0;
}

/*** sensor mutex_free ***/
static IOField _Event_Format_sensor_mutex_free_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_freePtr, mutex)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_free = 
    {1, 0, 0, "mutex_free", _Event_Format_sensor_mutex_free_};
int
DM_Sensor_mutex_free(mutex)
unsigned long  mutex;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_free)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_free);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_freePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_free);
        theSpecificSensor = (Sensor_Type_mutex_freePtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_free, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_free);
        }
    }
    return 0;
}

/*** sensor mutex_clear ***/
static IOField _Event_Format_sensor_mutex_clear_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_clearPtr, mutex)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_clear = 
    {1, 0, 0, "mutex_clear", _Event_Format_sensor_mutex_clear_};
int
DM_Sensor_mutex_clear(mutex)
unsigned long  mutex;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_clear)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_clear);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_clearPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_clear);
        theSpecificSensor = (Sensor_Type_mutex_clearPtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_clear, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_clear);
        }
    }
    return 0;
}

/*** sensor mutex_set_name ***/
static IOField _Event_Format_sensor_mutex_set_name_[] = {
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_mutex_set_namePtr, mutex)},
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_mutex_set_namePtr, name)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_mutex_set_name = 
    {1, 0, 0, "mutex_set_name", _Event_Format_sensor_mutex_set_name_};
int
DM_Sensor_mutex_set_name(mutex, name)
unsigned long  mutex;
char*          name;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_mutex_set_name)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_mutex_set_name);
        static char *aSensor = (char *)0;
        Sensor_Type_mutex_set_namePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_mutex_set_name);
        theSpecificSensor = (Sensor_Type_mutex_set_namePtr)(aSensor + sensor_header_size);
        theSpecificSensor->mutex = mutex;
        theSpecificSensor->name = name;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_mutex_set_name, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_mutex_set_name);
        }
    }
    return 0;
}

/*** sensor condition_alloc ***/
static IOField _Event_Format_sensor_condition_alloc_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_allocPtr, condition)},
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_condition_allocPtr, name)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_alloc = 
    {1, 0, 0, "condition_alloc", _Event_Format_sensor_condition_alloc_};
int
DM_Sensor_condition_alloc(condition, name)
unsigned long  condition;
char*          name;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_alloc)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_alloc);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_allocPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_alloc);
        theSpecificSensor = (Sensor_Type_condition_allocPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;
        theSpecificSensor->name = name;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_alloc, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_alloc);
        }
    }
    return 0;
}

/*** sensor condition_init ***/
static IOField _Event_Format_sensor_condition_init_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_initPtr, condition)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_init = 
    {1, 0, 0, "condition_init", _Event_Format_sensor_condition_init_};
int
DM_Sensor_condition_init(condition)
unsigned long  condition;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_init)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_init);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_initPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_init);
        theSpecificSensor = (Sensor_Type_condition_initPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_init, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_init);
        }
    }
    return 0;
}

/*** sensor condition_free ***/
static IOField _Event_Format_sensor_condition_free_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_freePtr, condition)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_free = 
    {1, 0, 0, "condition_free", _Event_Format_sensor_condition_free_};
int
DM_Sensor_condition_free(condition)
unsigned long  condition;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_free)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_free);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_freePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_free);
        theSpecificSensor = (Sensor_Type_condition_freePtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_free, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_free);
        }
    }
    return 0;
}

/*** sensor condition_clear ***/
static IOField _Event_Format_sensor_condition_clear_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_clearPtr, condition)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_clear = 
    {1, 0, 0, "condition_clear", _Event_Format_sensor_condition_clear_};
int
DM_Sensor_condition_clear(condition)
unsigned long  condition;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_clear)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_clear);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_clearPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_clear);
        theSpecificSensor = (Sensor_Type_condition_clearPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_clear, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_clear);
        }
    }
    return 0;
}

/*** sensor condition_begin_wait ***/
static IOField _Event_Format_sensor_condition_begin_wait_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_begin_waitPtr, condition)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_condition_begin_waitPtr, sequence_number)},
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_begin_waitPtr, mutex)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_begin_wait = 
    {1, 0, 0, "condition_begin_wait", _Event_Format_sensor_condition_begin_wait_};
int
DM_Sensor_condition_begin_wait(condition, sequence_number, mutex)
unsigned long  condition;
int            sequence_number;
unsigned long  mutex;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_begin_wait)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_begin_wait);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_begin_waitPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_begin_wait);
        theSpecificSensor = (Sensor_Type_condition_begin_waitPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;
        theSpecificSensor->sequence_number = sequence_number;
        theSpecificSensor->mutex = mutex;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_begin_wait, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_begin_wait);
        }
    }
    return 0;
}

/*** sensor condition_end_wait ***/
static IOField _Event_Format_sensor_condition_end_wait_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_end_waitPtr, condition)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_condition_end_waitPtr, sequence_number)},
    {"mutex", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_end_waitPtr, mutex)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_end_wait = 
    {1, 0, 0, "condition_end_wait", _Event_Format_sensor_condition_end_wait_};
int
DM_Sensor_condition_end_wait(condition, sequence_number, mutex)
unsigned long  condition;
int            sequence_number;
unsigned long  mutex;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_end_wait)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_end_wait);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_end_waitPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_end_wait);
        theSpecificSensor = (Sensor_Type_condition_end_waitPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;
        theSpecificSensor->sequence_number = sequence_number;
        theSpecificSensor->mutex = mutex;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_end_wait, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_end_wait);
        }
    }
    return 0;
}

/*** sensor condition_broadcast ***/
static IOField _Event_Format_sensor_condition_broadcast_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_broadcastPtr, condition)},
    {"begin_sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_condition_broadcastPtr, begin_sequence_number)},
    {"end_sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_condition_broadcastPtr, end_sequence_number)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_broadcast = 
    {1, 0, 0, "condition_broadcast", _Event_Format_sensor_condition_broadcast_};
int
DM_Sensor_condition_broadcast(condition, begin_sequence_number, end_sequence_number)
unsigned long  condition;
int            begin_sequence_number;
int            end_sequence_number;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_broadcast)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_broadcast);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_broadcastPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_broadcast);
        theSpecificSensor = (Sensor_Type_condition_broadcastPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;
        theSpecificSensor->begin_sequence_number = begin_sequence_number;
        theSpecificSensor->end_sequence_number = end_sequence_number;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_broadcast, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_broadcast);
        }
    }
    return 0;
}

/*** sensor condition_signal ***/
static IOField _Event_Format_sensor_condition_signal_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_signalPtr, condition)},
    {"sequence_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_condition_signalPtr, sequence_number)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_signal = 
    {1, 0, 0, "condition_signal", _Event_Format_sensor_condition_signal_};
int
DM_Sensor_condition_signal(condition, sequence_number)
unsigned long  condition;
int            sequence_number;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_signal)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_signal);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_signalPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_signal);
        theSpecificSensor = (Sensor_Type_condition_signalPtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;
        theSpecificSensor->sequence_number = sequence_number;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_signal, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_signal);
        }
    }
    return 0;
}

/*** sensor condition_set_name ***/
static IOField _Event_Format_sensor_condition_set_name_[] = {
    {"condition", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_condition_set_namePtr, condition)},
    {"name", "string", sizeof(char*),
        IOOffset(Sensor_Type_condition_set_namePtr, name)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_condition_set_name = 
    {1, 0, 0, "condition_set_name", _Event_Format_sensor_condition_set_name_};
int
DM_Sensor_condition_set_name(condition, name)
unsigned long  condition;
char*          name;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_condition_set_name)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_condition_set_name);
        static char *aSensor = (char *)0;
        Sensor_Type_condition_set_namePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_condition_set_name);
        theSpecificSensor = (Sensor_Type_condition_set_namePtr)(aSensor + sensor_header_size);
        theSpecificSensor->condition = condition;
        theSpecificSensor->name = name;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_condition_set_name, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_condition_set_name);
        }
    }
    return 0;
}

/*** sensor program_exit ***/
static IOField _Event_Format_sensor_program_exit_[] = {
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_program_exit = 
    {1, 0, 0, "program_exit", _Event_Format_sensor_program_exit_};
int
DM_Sensor_program_exit()
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_program_exit)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_program_exit);
        static char *aSensor = (char *)0;
        Sensor_Type_program_exitPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_program_exit);
        theSpecificSensor = (Sensor_Type_program_exitPtr)(aSensor + sensor_header_size);

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_program_exit, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_program_exit);
        }
    }
    return 0;
}

/*** sensor monitor_exit ***/
static IOField _Event_Format_sensor_monitor_exit_[] = {
    {"lm_number", "integer", sizeof(int),
        IOOffset(Sensor_Type_monitor_exitPtr, lm_number)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_monitor_exit = 
    {1, 0, 0, "monitor_exit", _Event_Format_sensor_monitor_exit_};
int
DM_Sensor_monitor_exit(lm_number)
int            lm_number;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_monitor_exit)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_monitor_exit);
        static char *aSensor = (char *)0;
        Sensor_Type_monitor_exitPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_monitor_exit);
        theSpecificSensor = (Sensor_Type_monitor_exitPtr)(aSensor + sensor_header_size);
        theSpecificSensor->lm_number = lm_number;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_monitor_exit, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_monitor_exit);
        }
    }
    return 0;
}

/*** sensor thread_off_runq ***/
static IOField _Event_Format_sensor_thread_off_runq_[] = {
    {"thread_off_runq", "integer", sizeof(unsigned long),
        IOOffset(Sensor_Type_thread_off_runqPtr, thread_off_runq)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_thread_off_runq = 
    {1, 0, 0, "thread_off_runq", _Event_Format_sensor_thread_off_runq_};
int
DM_Sensor_thread_off_runq(thread_off_runq)
unsigned long  thread_off_runq;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_thread_off_runq)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_thread_off_runq);
        static char *aSensor = (char *)0;
        Sensor_Type_thread_off_runqPtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_thread_off_runq);
        theSpecificSensor = (Sensor_Type_thread_off_runqPtr)(aSensor + sensor_header_size);
        theSpecificSensor->thread_off_runq = thread_off_runq;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_thread_off_runq, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_thread_off_runq);
        }
    }
    return 0;
}

/*** sensor processor_begin_idle ***/
static IOField _Event_Format_sensor_processor_begin_idle_[] = {
    {"processor", "integer", sizeof(unsigned short),
        IOOffset(Sensor_Type_processor_begin_idlePtr, processor)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_processor_begin_idle = 
    {1, 0, 0, "processor_begin_idle", _Event_Format_sensor_processor_begin_idle_};
int
DM_Sensor_processor_begin_idle(processor)
unsigned short processor;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_processor_begin_idle)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_processor_begin_idle);
        static char *aSensor = (char *)0;
        Sensor_Type_processor_begin_idlePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_processor_begin_idle);
        theSpecificSensor = (Sensor_Type_processor_begin_idlePtr)(aSensor + sensor_header_size);
        theSpecificSensor->processor = processor;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_processor_begin_idle, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_processor_begin_idle);
        }
    }
    return 0;
}

/*** sensor processor_end_idle ***/
static IOField _Event_Format_sensor_processor_end_idle_[] = {
    {"processor", "integer", sizeof(unsigned short),
        IOOffset(Sensor_Type_processor_end_idlePtr, processor)},
    {NULL, NULL, 0, 0}
};

static sensor_descriptor Sensor_Descriptor_processor_end_idle = 
    {1, 0, 0, "processor_end_idle", _Event_Format_sensor_processor_end_idle_};
int
DM_Sensor_processor_end_idle(processor)
unsigned short processor;
{
    if (sensor_test_switch && (sensor_test_switch)(&Sensor_Descriptor_processor_end_idle)) {
        int sensor_size = sensor_header_size + sizeof(Sensor_Type_processor_end_idle);
        static char *aSensor = (char *)0;
        Sensor_Type_processor_end_idlePtr  theSpecificSensor; 

        if (aSensor == (char *) 0) aSensor = malloc(sensor_size);
        if (sensor_init_header)
             (sensor_init_header)(aSensor, &Sensor_Descriptor_processor_end_idle);
        theSpecificSensor = (Sensor_Type_processor_end_idlePtr)(aSensor + sensor_header_size);
        theSpecificSensor->processor = processor;

        while(!(sensor_non_blocking_submit_event)(aSensor, sensor_size, &Sensor_Descriptor_processor_end_idle, sensor_transport_info)) {
            if (sensor_update_header)
              (sensor_update_header)(aSensor, Sensor_Descriptor_processor_end_idle);
        }
    }
    return 0;
}

