/* process this file with "sensor -prefix DM_Sensor" for monitoring sensors */


sensor thread_init {
    attributes {
	char	   *name;
	int		   num_processors;
	int		   num_lms;
	int		   on_processor;
	unsigned long  timestamp_resolution;
    }
};


/*** sensor thread_fork ***/

sensor thread_fork {
    attributes {
	char	   *name;
	unsigned long  child_thread;
	int		   sequence_number;
	int		   on_processor;
    }
};


/*** sensor thread_exit ***/

sensor thread_exit {
};


/*** sensor thread_begin_join ***/

sensor thread_begin_join {
    attributes {
	unsigned long  join_to;
    }
};


/*** sensor thread_end_join ***/

sensor thread_end_join {
    attributes {
	unsigned long  join_to;
    }
};


/*** sensor thread_detach ***/

sensor thread_detach {
    attributes {
	unsigned long  detach_from;
    }
};


/*** sensor thread_yield ***/

sensor thread_yield {
};


/*** sensor thread_set_name ***/

sensor thread_set_name {
	attributes {
	    unsigned long the_thread;
	    char  *name;
	}
};


/*** sensor mutex_begin_lock ***/

sensor mutex_begin_lock {
    attributes {
	unsigned long  mutex;
	int		   sequence_number;
    }
};


/*** sensor mutex_end_lock ***/

sensor mutex_end_lock {
    attributes {
	unsigned long  mutex;
	int		   sequence_number;
    }
};


/*** sensor mutex_unlock ***/

sensor mutex_unlock {
    attributes {
	unsigned long  mutex;
	int		   sequence_number;
    }
};


/*** sensor mutex_alloc ***/

sensor mutex_alloc {
    attributes {
	unsigned long  mutex;
	char	   *name;
    }
};


/*** sensor mutex_init ***/

sensor mutex_init {
    attributes {
	unsigned long  mutex;
    }
};


/*** sensor mutex_free ***/

sensor mutex_free {
    attributes {
	unsigned long  mutex;
    }
};


/*** sensor mutex_clear ***/

sensor mutex_clear {
    attributes {
	unsigned long  mutex;
    }
};


/*** sensor mutex_set_name ***/

sensor mutex_set_name {
    attributes {
	unsigned long  mutex;
	char	   *name;
    }
};


/*** sensor condition_alloc ***/

sensor condition_alloc {
    attributes {
	unsigned long  condition;
	char	   *name;
    }
};


/*** sensor condition_init ***/

sensor condition_init {
    attributes {
	unsigned long  condition;
    }
};


/*** sensor condition_free ***/

sensor condition_free {
    attributes {
	unsigned long  condition;
    }
};


/*** sensor condition_clear ***/

sensor condition_clear {
    attributes {
	unsigned long  condition;
    }
};


/*** sensor condition_begin_wait ***/

sensor condition_begin_wait {
    attributes {
	unsigned long  condition;
	int		   sequence_number;
	unsigned long  mutex;
	}
};


/*** sensor condition_end_wait ***/

sensor condition_end_wait {
    attributes {
	unsigned long  condition;
	int		   sequence_number;
	unsigned long  mutex;
    }
};


/*** sensor condition_broadcast ***/

sensor condition_broadcast {
    attributes {
	unsigned long  condition;
	int		   begin_sequence_number;
	int		   end_sequence_number;
    }
};


/*** sensor condition_signal ***/

sensor condition_signal {
    attributes {
	unsigned long  condition;
	int		   sequence_number;
    }
};


/*** sensor condition_set_name ***/

sensor condition_set_name {
    attributes {
	unsigned long  condition;
	char	   *name;
    }
};


/*** exit cthread program ***/

sensor program_exit {
};


/*** monitor thread exit ***/

sensor monitor_exit {
    attributes {
	int			   lm_number;
    }
};


sensor thread_off_runq {
    attributes {
	unsigned long thread_off_runq;
    }
};


sensor processor_begin_idle {
    attributes {
	unsigned short processor;
    }
};

sensor processor_end_idle {
    attributes {
	unsigned short processor;
    }
};

