/*
 * Memory allocator.
 *
 * Modification history:
 *
 * 1.0   3-May-88    Initial release.
 * 1.2	20-May-88	New version. Buddy memory allocator.
 * 2.0  21-June-94	Removed built-in limit on managed memory.  GSE.
 */
#ifndef MEMALLOC_H
#define MEMALLOC_H

#define		MIN_CHUNK	4
#define		MIN_CHUNK_SIZE	(1<<MIN_CHUNK)	/* Smaller block 16 bytes
						   (12 avail * to the user) */
#define		M_FREE	0
#define		M_USED	1


typedef		struct	bucket {
    struct	bucket	*next, *prev;
    char	chlen;
} *bucket_t;

typedef	struct mem_free_list {
  LOCK memlock;
  unsigned long	total_mem_free;
  unsigned long	base;
  short	biggest_chunk;
  short	chunk_limit;
  struct bucket buckets[1];  /* last array expands with malloc */
} *mem_free_list_t;


typedef	struct	mem_header {
  unsigned char processor,
  bucket_size,
  padd,
  tag;				/* This tag should be at the end	*/
} *mem_header_t;		/* because if it is 1 (M_USED) means*/
				/* That the memory module is in use */
				/* But when it gets freed, since in */
				/* its place a pointer is going to	*/
				/* be stored (and we have pointers  */
				/* only to even addresses, it will	*/
				/* be reseted automatically.		*/

typedef long *memory_t;


bucket_t
  ddequeue ARGS((bucket_t dqueue));

void
  dremove ARGS((bucket_t dq));

void
  init_dqueue ARGS((bucket_t dq));

void
  denqueue ARGS((bucket_t dqueue,
		 bucket_t dqitem));

RESULT
  memory_alloc ARGS((memory_t *ptr,
		     int size,
		     int node));

void
  memory_free ARGS((memory_t mptr));

void
  deb_buddy_mem ARGS((int procno));

void
  deb_mem_struct ARGS((int procno));

#endif
