#include        <varargs.h>

#include        "general.h"
#include        "results.h"
#include        "lock.h"
#include        "queue.h"
#include        "sync.h"
#include        "internal.h"
extern  shared	struct  local_info  *processor;
extern  private	cthread_t           current_thread_array[MAX_PROC];
extern 		int 	            next_thread_type;
#include	"arch_sync.h"

extern void child_exit ARGS((int));

void
registration(c)
cflock_t        c;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];
    cthread_t ttmp = current_thread;
    enqueue(&c->squeue, (queue_item_t)ttmp);
}

void 
acquire(c)
cflock_t        c;
{
	int st;
	LOCK *loclock;

	if (c->stime) {
   		cthread_spin_lock(&c->tmp_lock);
   		if (TRY_TO_LOCK(&c->clock) != M_LOCKED) {
			registration(c);
			st = c->stime;
      			cthread_spin_unlock(&c->tmp_lock);
			loclock = (c->loclock)[virtual_processor()];
   		}
   		else {
			cthread_spin_unlock(&c->tmp_lock);
			return;
		}
                for(;;) {
			if (st-- == 0) break;
			if (TRY_TO_LOCK(loclock) == M_LOCKED) return;
		}
	}
	if (c->btime) {
		block_lock((block_t)c);
	} else {
	    fprintf(stderr, "illegal lock configuration on proc %d",
		    virtual_processor());
	    child_exit (1);
	}
}

/* The following function implements the scheduling policy */

void
release (c)
cflock_t        c;
{
   register     cthread_t       ttmp;
   if ((ttmp = (cthread_t)dequeue(&c->squeue)) == 0) {
         if ((ttmp = (cthread_t)dequeue(&c->bqueue)) == 0)
   		LOCK_INIT(c->clock);
	 else       
              	locked_enqueue(processor[ttmp->on_node].lqueue, ttmp);
   } else {
       LOCK_INIT(*(c->loclock[ttmp->on_node]));
   }
}
