/* linux.c */

#include <sys/types.h>
#include <stdio.h>

#include "assert.h"
#include "general.h"
#include "internal.h"
#include "hwlib.h"
#include "linux_init.h"

/* defined in threads.c */
void start_thread ARGS((int (*func)(), any_t arg));
void start_threadV ARGS((int	(* func)(), int	n, any_t arg));
extern cthread_t current_thread_array[MAX_PROC];
extern void internal_cthread_exit();

static void
exchange(lock, val, out)
u_int *lock;
u_int val;
u_int *out;
{
    /* xchg val,*lock */
    asm("movl 8(%ebp),%edx");	  /* edx = lock */
    asm("movl 12(%ebp),%ecx");	  /* ecx = val */
    asm("xchg %ecx,(%edx) ");     /* xchg *edx, val */
    asm("movl 16(%ebp),%edx");	  /* edx = out */
    asm("movl %ecx,(%edx)");      /* *out = what was in lock */
}

int TRY_TO_LOCK(l)
LOCK *l;
{
        u_int out = 0;
        exchange(l, 0x00ff, &out);
        return out;
}

/* int sp; */

void
fix_jbuf(t, func, arg)
cthread_t	t;
any_t 	(*func)();
long 	*arg;
{
   long *sp;

   if (setjmp(*(t->jbuf)) != 0)
   {
      fprintf(stderr,"FATAL ERROR: Unexpected return from setjmp in fix_jbuf");
   }

   /* init the stack so we can just do a longjmp and it will call start_thead */
   /* make the final return address point to thread exit to catch returns */
   sp = (long *)t->stack_top;
   *(--sp) = (long) arg;  /* arg 2 */
   *(--sp) = (long) func; /* arg 1 */
   *(--sp) = (long)internal_cthread_exit;

   /* init the jmp buffer */
#ifdef JB_SP
   /* 
    * braindead RedHat makes this an array of int's.  
    * Long is the only reasonable type to use for an array of mostly addrs.
    */
   (*t->jbuf)[0].__jmpbuf[JB_SP] = (int) sp;
   (*t->jbuf)[0].__jmpbuf[JB_PC] = (int) start_thread;
#else
   (*t->jbuf)[0].__sp = sp;
   (*t->jbuf)[0].__pc = start_thread;
#endif
}

void
DISPATCH(thread)
cthread_t thread;
{
    if ((thread)->already_started) 
    { 
	DBG2("calling longjmp, buf[1] is %lx thread %lx\n",
	       (long)(thread)->jbuf[1], (long)thread);

	longjmp(*((thread)->jbuf), 1);
    } 
    else 
    {
	fix_jbuf(thread, thread->func, (long *)thread->arg);

	DBG2("calling MY_longjmp, buf[1] is %lx thread %lx\n",
	       (long)(thread)->jbuf[1], (long)thread);

	(thread)->already_started = 1;

	longjmp(*((thread)->jbuf), 1);
    }
}

void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];

    if(setjmp(*(current_thread->jbuf)) == 0) {
	/* 
	**  0 return from setjmp the first time the buffer is set.
	**  value is non-zero when we longjmp back here
	*/
	(func)(arg);

	/* func should never return */
	assert(FALSE);
    }
}

void *
get_sp_from_context(context_ptr)
cthread_context *context_ptr;
{
    return(context_ptr[4]);
}

