/*
**   machine specific defines for synchronization on the KSR
*/
#ifndef __KSR_SYNC_H
#define __KSR_SYNC_H

typedef __align128 volatile int LOCK;
typedef	LOCK	*LOCK_T;
typedef volatile __align128 short atom_int;
#define	LOCK_INIT(l)	(l=0)
#define	GOT_SUBPAGE	1

/*
** the defines below this are used only in sync.c
*/


#define ATOM_ADD_LOCK (LOCK *) i

#define	SPIN_LOCK(sl)	while(!_gspnwt(sl))
/* old version below commented out pending KSR hardware/OS fixes... */
/*#define	SPIN_LOCK(sl)	_gspwt(sl)*/

#define	SPIN_UNLOCK(sl)   {		\
			_rsp(sl);	\
			}

#define	MUTEX_LOCK(m)	while (TRY_TO_LOCK(m) != GOT_SUBPAGE) internal_cthread_yield()

#define	MUTEX_UNLOCK(m)  {			\
			_rsp(m);		\
			}

#endif
