/*
 * Contains the function which sets the jump buffer initially. It is
 * highly machine depented so it was separated from the rest of the
 * library.
 *
 */

#include <stdio.h>
#include "assert.h"
#include "results.h"
#include "general.h"
#include "internal.h"
#include "hwlib.h"

extern	any_t	start_thread();
extern	any_t	start_threadV();
extern 		internal_cthread_exit();

#define         CONSTANT_POINTER 15
#define		PROGRAM_COUNTER	 18
#define		FRAME_POINTER	 16
#define		STACK_POINTER	 17

extern 	cthread_t	current_thread_array[MAX_PROC];

void
start_fresh_thread(t, func, arg)
cthread_t	t;
any_t 	(*func)();
long 	*arg;
{
    long	*lptr;
    int		result;

    if ((result = _setjmp(t->jbuf)) != 0) {
	start_thread(func, (char *)arg);
	printf("PANIC: Error in thread creation\n");
	exit(0);
   }
   else {
       lptr = (long *)((long) t->stack_top - 128);
       t->jbuf[STACK_POINTER] = (long)lptr ;
       t->jbuf[FRAME_POINTER] = (long) t->stack_top;
       _longjmp(t->jbuf, 1);
    }
}

void
DISPATCH(thread)
cthread_t thread;
{
    if ((thread)->already_started) { 
	DBG2("calling longjmp, buf[1] is %x thread %x\n",
	       (long)(thread)->jbuf[1], (long)thread);
	_longjmp((thread)->jbuf, 1);
    } else {
	DBG1("calling fixjbuf for thread %x\n", (long)thread);
	(thread)->already_started = 1;
	start_fresh_thread((thread), (thread)->func, (thread)->arg);
    }
}


void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[current_processor()];

    if(_setjmp(current_thread->jbuf) == 0) {
	/* 
	**  0 return from setjmp the first time the buffer is set.
	**  value is non-zero when we longjmp back here
	*/
	(func)();

	assert(FALSE);
    }
}

void *
get_sp_from_context(context_ptr)
cthread_context context_ptr;
{
    return (void *) context_ptr[STACK_POINTER];
}

/*
**  TRY_TO_LOCK is a subroutine rather than a macro to avoid a bug
**  in the KSR CC optimizer.  This affected code generation for
**  internal_mutex_unlock().  GSE  Sept 14, 1993.  KSR OS 1.1.4
*/
int
TRY_TO_LOCK(l)
LOCK *l;
{
    return _gspnwt(l);
}
