
/* initial handshaking message */
typedef struct _HubFirstMsg {
    char *hub_name;
    int  hub_id;
    char *mach_name;
    int  port, pid;
    char *usock_name;
    int  default_forward;
} HubFirstMsg, *HubFirstMsgPtr;

static IOField hub_first_msg_flds[] =
{
    {"hub_name", "string", sizeof(char*), IOOffset(HubFirstMsgPtr, hub_name)},
    {"hub_id", "integer", sizeof(int), IOOffset(HubFirstMsgPtr, hub_id)},
    {"mach_name", "string", sizeof(char*), IOOffset(HubFirstMsgPtr, mach_name)},
    {"port", "integer", sizeof(int), IOOffset(HubFirstMsgPtr, port)},
    {"pid", "integer", sizeof(int), IOOffset(HubFirstMsgPtr, pid)},
    {"usock_name", "string", sizeof(char*), IOOffset(HubFirstMsgPtr, usock_name)},
    {"default_forward", "integer", sizeof(int),
     IOOffset(HubFirstMsgPtr, default_forward)},
    {NULL, NULL, 0, 0},
};


/* format sign on or off msg */
typedef struct _FormatSignMsg {
    int  requester_id;		/* hub_id of requester */
    char *format_name;
} FormatSignMsg, *FormatSignMsgPtr;

static IOField format_sign_msg_flds[] =
{
    {"requester_id", "integer", sizeof(int),
     IOOffset(FormatSignMsgPtr, requester_id)},
    {"format_name", "string", sizeof(char*),
     IOOffset(FormatSignMsgPtr, format_name)},
    {NULL, NULL, 0, 0},
};


/* shut down system or just close a connection link */
typedef struct _ShutDownMsg {
    int  whom;		/* shut down whom */
    char *message;
    char *hub_name;
    int  hub_id;
} ShutDownMsg, *ShutDownMsgPtr;

static IOField shut_down_msg_flds[] =
{
    {"whom", "integer", sizeof(int), IOOffset(ShutDownMsgPtr, whom)},
    {"message", "string", sizeof(char*), IOOffset(ShutDownMsgPtr, message)},
    {"hub name", "string", sizeof(char*), IOOffset(ShutDownMsgPtr, hub_name)},
    {"hub id", "integer", sizeof(int), IOOffset(ShutDownMsgPtr, hub_id)},
    {NULL, NULL, 0, 0},
};

/***** EOF *****/
