/* 
 *internal.h
 * Modification history:
 *
 * 1.0	 3-May-88	Initial release.
 * 1.2	20-May-88	Delete the stack_OID field from the thread control block.
 * 1.3  01-Nov-88	Port to MACH. The field terminate added in the structure
 *					local_info to implement the termination procedure for the
 *					participating processes under MACH.
 * 1.4	19-Apr-89	(Ahmed Gheith) Added cthread_sleep :
 *			   -  SLEEPING bit.
 *			   -  actat field.
 * 1.5	20-Apr-89	(Ahmed Ghieth) Added events:
 *				Add event queue to thread decsriptor
 *				Define S_EVENT status bit
 * 1.6	07-May-89	(Ahmed Gheith) Added onblock/whenblock
 * 1.7	27-May-89	(Ahmed Gheith) Added thread migration.
 * 1.8   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.9   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.10  Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.11  Bodhi Mukherjee	Added Implementation for Sequent.
 *
 */

#ifndef INTERNAL_H
#define INTERNAL_H

#include "config.h"
#ifdef HAVE_SETJMP_H
#include <setjmp.h>
#endif

#include "cthread_context.h"

#include "lock.h"
#include "queue.h"
#include "sched_utils.h"
#include "sync.h"

#include "monitor_buf.h"

typedef struct io_info *io_info_t;

typedef struct sched {
                LOCK sched_lock;
   		locked_queue_t free_list; /* Scheduler free list of threads*/
   		locked_queue_t *lqueue; /* Scheduler ready queues */

                int  no_of_readyqs;
                int  node;
                void *sched_thread; 
		atom_int  active_threads;

		void *(*sched_global_init)();
		void *(*sched_vproc_init)();
		void *(*sched_thread_init)();
		void *(*sched_get_thread)();
		void *(*sched_put_thread)();
		void *(*sched_empty_readyq)();
		void *(*schedule)();
		void *(*proc_idle)();
		void (*alert_hndlrs[NO_OF_SIGNALS])();

		int     pending_io_count;
		io_info_t io;  /* remaining IO information */

} *sched_info_t;

typedef	struct	local_info {
#ifdef __ksr__
   processor_name_t logical_to_phys;
#else
   int		logical_to_phys;/* The physical node number of this node*/
   				/* "signal" among the processors. See 	*/
#endif
   atom_int	load;		/* number of queued threads */
   short	terminate;	/* Used to propagate termination */
   sched_info_t scheduler;	/* Per-processor scheduler		*/
   int		scheduler_pc;	/* pc for scheduler re-entry (hack)	*/
   cthread_context  scheduler_jbuf; /* used to jump back to the scheduler */
} *local_info_t;

/* values for the 'type' field in pending_io_block structure */

#define NO_PENDING_IO     0
#define PENDING_RECV      1
#define PENDING_RECVFROM  2
#define PENDING_READV     3
#define PENDING_ACCEPT    4
#define PENDING_SEND      5
#define PENDING_SENDTO    6
#define PENDING_WRITEV    7          
#define PENDING_CONNECT   8      
 
typedef struct pending_io_block {
  int    type;     
  int    socket;
  void   *addr;
  int    addrlen;
  char   *buf;
  int    len;
  int    flags;
} *pending_io_block_t;

/* 
 *	Terminate values	
 */
#define		DONT_TERMINATE		0
#define		TERMINATE		1

typedef	struct	cthread {
   any_t	next;		/* next in the queue (MUST be the first)*/
   void 	*stack_top;
   void		*usable_stack_base;
   void		*usable_stack_limit;
   cthread_context	jbuf;
   LOCK		tlock;
   string_t	name;
   any_t	return_value;
   int		status;		/* status of the thread. See below	*/
   int		wstatus;	/* waiting status of the thread 	*/
   any_t	thread_data;
   short	home,		/* home node				*/
   		origin_node,
                on_node;	/* current node (usually home)		*/
   any_t	agent;		/* owner of borrowed stack (migration)	*/
   struct condition	done;
   short	synced;
   short	already_started;
   int		actat;		/* absolute time to reactivate the thread */
   int		schedule_type;
   void 	*sched_info;	/* generic field for giving info to	*/
   				/*   custom written schedulers		*/
   int          sensor_switch;  /* Sensor switch for this thread */
   void	*mon_info;  /* pointer used to store monitoring information */
   /* the fork count below is used with monitoring differentiate between
      different thread instances which use the same TCB.
   */
   int	fork_count;
   long	*arg;
   any_t     (*func)();
   struct pending_io_block   io;
} *cthread_t;

extern cthread_t *initial_thread;
extern cthread_t *monitor_threads;
extern cthread_t *steer_thread;
extern cthread_t *adv_steer_thread;

/*
 * The status bits of a thread.
 */

#define	S_INITIALLY	0x00	/* The initial value of the status */
#define	S_FINISHED	0x01
#define	S_DETACHED	0x02
#define	S_JOINING	0x04
#define	S_FREED		0x08
#define	S_MAIN		0x10
#define S_ON_BARRIER	0x20
#define S_INTERNAL	0x0100	/* TAG internally created threads */

#endif
