
#ifndef INIT_H
#define INIT_H

typedef unsigned char	*proc_list_t;

#define	DEFAULT_PROC_LIST	0

#define	O_PHYS_TO_LOGICAL	0
#define	O_NUM_OF_PROCS		1
#define	O_TOTAL_THREADS		2
#define	O_PROCESSOR		3
#define	O_MEMORY_POOL		4
#define	O_SYNC_INIT		5
#define	O_NEXT_FREE		6
/*
 * After O_NEXT_FREE we have 2 OID's per processor. One is its local
 * thread queue OID and the other is its dynamic memory segment contribution
 */

#define	PROC_ANY		-1

#define	PROC_CURRENT		-1

#define	DYNAMIC_MEMORY_PER_PROCESSOR	(1<<MEMORY_EXPONENT	)

typedef struct configuration {
   int	stack_size,
   	memory_exponent,
   	threads_per_proc;
} *configuration_t;

extern struct configuration config;

extern int allow_core_dumps;

#define	DEFAULT_STACK		-1
#define	DEFAULT_MEM		-1
#define	DEFAULT_THREADS		-1
#define	DEFAULT_READYQS		-1

#define	GET_CONFIG		0
#define	PUT_CONFIG		1

#define	CONFIGURED		1
#define	NOT_CONFIGURED		0

#define	PROC_SENTINEL		0	/* Process table sentinel	*/

#define SHARED_SHORT_SPACE 8192         /* arbitrarily allocate one page
                                         * size for shared count variables
                                         * such as num_of_procs, etc.
                                         */
#define PROCESSES_TABLE_SIZE 8192       /* same comment as above */

void
  error_exit ARGS((char	*label,
		   char *message,
		   int error,
		   int node,
		   int size));

void
  Delay ARGS((int interv));

any_t
  allocate_and_share ARGS((unsigned size,
			   int node));

any_t
allocate_and_copy ARGS((unsigned size));

any_t fake ARGS((any_t (*start_func)()));

void
  procinit ARGS((int node));

RESULT
  cthread_configure ARGS((configuration_t conf,
			  int action));

RESULT cthread_init ARGS((int procs,	/* Number of processors	*/
		     void (*start_func)()));

void internal_cthread_publish ARGS((any_t *p));

extern void start_proc_initial_thread ARGS((int (*func)()));

extern RESULT init_shared_data ARGS((int total_procs));

extern int generic_shared_size ARGS((int procs));
extern int generic_monmem_size ARGS((int procs));

#endif
