/* linux.c */

#include <sys/types.h>
#include <stdio.h>

#include "assert.h"
#include "general.h"
#include "internal.h"
#include "hwlib.h"
#include "i86pc_init.h"
#include "init.h"

/* defined in threads.c */
void start_thread ARGS((int (*func)(), any_t arg));
void start_threadV ARGS((int	(* func)(), int	n, any_t arg));
extern cthread_t current_thread_array[MAX_PROC];
extern void internal_cthread_exit();

static void
exchange(lock, val, out)
u_int *lock;
u_int val;
u_int *out;
{
    /* xchg val,*lock */
    asm("movl 8(%ebp),%edx");	  /* edx = lock */
    asm("movl 12(%ebp),%ecx");	  /* ecx = val */
    asm("xchg %ecx,(%edx) ");     /* xchg *edx, val */
    asm("movl 16(%ebp),%edx");	  /* edx = out */
    asm("movl %ecx,(%edx)");      /* *out = what was in lock */
}

int TRY_TO_LOCK(l)
LOCK *l;
{
        u_int out = 0;
        exchange(l, 0x00ff, &out);
        return out;
}

void
fix_jbuf(thread, func, arg)
cthread_t thread;
any_t (*func)();
long *arg;
{
    getcontext(thread->jbuf);

    /* round the stack value down to something divisible by 8 
       and substitute it in for the sp in the context */
    thread->jbuf->uc_stack.ss_sp = (char*)((long)thread->usable_stack_base & ~0xf);
    thread->jbuf->uc_stack.ss_sp -= CONTEXT_FUDGE_VALUE;
    thread->jbuf->uc_stack.ss_size = config.stack_size;
    thread->jbuf->uc_stack.ss_flags = 0;
    DBG1("stack pointer in fix_jbuf is %lx\n", 
	 (long)thread->jbuf->uc_stack.ss_sp);
    makecontext(thread->jbuf, (void(*)()) start_thread, 3, func, arg);
    DBG1("stack pointer after makecontext is %lx\n", 
	 (long)thread->jbuf->uc_stack.ss_sp);
}

void
DISPATCH(thread)
cthread_t thread;
{
    if (!(thread)->already_started) { 
	(thread)->already_started = 1;
	fix_jbuf(thread, thread->func, thread->arg);
    }
    setcontext((thread)->jbuf);
}

void
swap_context_with_func(func, arg)
void (*func)();
void *arg;
{
    cthread_t current_thread = current_thread_array[virtual_processor()];
    ucontext_t tmp_context;
    int addr_diff;
    char *sp_guess = ((char *)&tmp_context) - sizeof(tmp_context) - 0x100;

    getcontext(&tmp_context);
    DBG3("[%d] swap context context %lx, sp = %lx\n", virtual_processor(),
	 (long)&tmp_context, 
	 (long)tmp_context.uc_stack.ss_sp);
    DBG3("base=%lx, top=%lx, limit=%lx\n", 
	 (unsigned long) current_thread->stack_top,
	 (unsigned long) current_thread->usable_stack_base, 
	 (unsigned long) current_thread->usable_stack_limit);
    /*
    ** oddly, the sp in the context seems to be *NOT* the one we're 
    ** currently executing on.  Why is this?  I don't know.  Substitute
    ** a better value (128 bytes past the end of the context local variable)
    */
    if (((void*)tmp_context.uc_stack.ss_sp > (void*)current_thread->usable_stack_base) ||
	((void*)tmp_context.uc_stack.ss_sp < (void*)current_thread->usable_stack_limit)) {
        /* if it's not in our assigned stack */
        addr_diff = (long)tmp_context.uc_stack.ss_sp - (long)sp_guess;
        if (addr_diff < 0) addr_diff = -addr_diff;
	DBG1("Addr diff is %lx\n", (unsigned long)addr_diff);
	if (addr_diff > 0x4000) {
	    /* 
	     *  OY.  The value of 0x4000 above is wholy arbitrary, as the 
	     *  behaviour of getcontext seems to be.
	     *  My assumption is that getcontext is greatly confused when
	     *  the SP isn't where it expects it to be (such as when we're 
	     *  executing on the stack of our own allocation) and thus it
	     *  returns some funky values.  What all this rather ugly
	     *  conditional code tries to do is attempts to put things right,
	     *  to set a reasonable SP despite the vagaries of getcontext().
	     */
	    tmp_context.uc_stack.ss_sp = (char *) ((long)sp_guess);
	}
    }
    DBG2("swap context2 %lx, sp = %lx\n", (long)&tmp_context, 
	 (long)tmp_context.uc_stack.ss_sp);
    makecontext(&tmp_context, func, 2, arg);
    DBG3("[%d]swap context, swapout thread %lx, func %lx\n", 
	 virtual_processor(), (long) current_thread, (long) func);
    if (swapcontext(current_thread->jbuf, &tmp_context) != 0)
      perror("swapcontext");
}

void *
get_sp_from_context(context_ptr)
cthread_context context_ptr;
{
    return(context_ptr->uc_stack.ss_sp);
}
