/*
 *  general.h
 *
 *  Contains compiler macros
 *  This should be the first threads .h file referenced in all .c files  
 *
 * Modification history:
 *
 * 1.0	3-May-88	Initial release
 * 1.1   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.2   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.4   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.5   Bodhi Mukherjee	Added Implementation for Sequent.
 */

#ifndef GENERAL_H
#define GENERAL_H

#include "config.h"
#include <stdio.h>
#ifdef STDC_HEADERS
#include <stdlib.h>
#endif

#define		exported
#if !defined(SEQUENT) && !defined(__ksr__)
#define		private
#define		shared
#endif

#ifdef __ksr__
/* get any_t definition and a few others */
#include "pthread.h"
#define private __private
#define shared __shared
#define align __align128
#else
typedef	char	*any_t;
#define align
#endif
typedef	char	*string_t;

#define	N_ANYWHERE	-2
#define	N_CURRENT	-1
#define	N_LESS		-3

#if defined(__STDC__) || defined(FUNCPROTO)
#define ARGS(args) args
#ifndef	NULL
/*
 * NULL --
 *	Null pointer.
 */
#define NULL	((void *) 0)
#endif
#else
#define ARGS(args) (/*args*/)
#ifndef	NULL
/*
 * NULL --
 *	Null pointer.
 */
#define NULL	0
#endif
#endif

#ifndef __GNUC__	/* GNU cc */
#define inline
#endif

/* MAX -- Return the maximum of two numbers. */
/* commonly defined, but how to make sure other definitions are the same? */
#ifndef MAX
#define MAX(x, y)	((x) > (y) ? (x) : (y))
#endif

/* MIN -- Return the minimum of two numbers. */
#ifndef MIN
#define MIN(x, y)	((x) < (y) ? (x) : (y))
#endif

/* ABS -- Return the absolute value of the argument. */
#define ABS(x)		((x) >= 0 ? (x) : -(x))


#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif

extern int debug_table_size;
extern int debug_query ARGS((char *name));

#ifndef MACH
#define getphysaddr(s) (s)
#endif

#ifndef NODEBUG

#ifndef FPRINTF_DEFINED
extern int fprintf ARGS((FILE *, const char *, ...));
#endif
#ifndef PRINTF_DEFINED
extern int printf ARGS((const char *, ...));
#endif

#define DBG(f) 		{\
			   if ((debug_table_size > 0)&&debug_query(__FILE__)){\
			       printf(f);\
			   }\
			 }
#define DBG1(f, a) 	{\
			   if ((debug_table_size > 0)&&debug_query(__FILE__)){\
		               printf(f, a);\
			   }\
			 }
#define DBG2(f, a, b) 	{\
			   if ((debug_table_size > 0)&&debug_query(__FILE__)){\
 				printf(f, a, b);\
			   }\
			 }
#define DBG3(f, a, b, c) {\
			   if ((debug_table_size > 0)&&debug_query(__FILE__)){\
				printf(f, a, b, c);\
			   }\
			 }
#define DBG4(f, a, b, c, d) {\
			   if ((debug_table_size > 0)&&debug_query(__FILE__)){\
	        		printf(f, a, b, c, d);\
			   }\
			 }

#else

#define DBG1(f, a)
#define DBG2(f, a, b)
#define DBG3(f, a, b, c)
#define DBG4(f, a, b, c, d)

#endif


#include "results.h"
#include "limits.h"

#endif
