/*
 * 2.0	Configurable threads.
 */
  
#ifndef CTHREAD_H
#define CTHREAD_H
#lockdef
typedef void *cthread_context;

/*
 * Exported library data structures.
 */

#define N_ANYWHERE  -2	/* fork a thread on a node (we don't care which)    */
#define N_CURRENT   -1	/* fork a thread on the current node	*/


#ifdef __STDC__         /* ANSI C */
#define ARGS(args) args
#else
#define ARGS(args) (/*args*/)
#endif

typedef struct	cth_mutex {	/* don't reference these fields directly !*/
	LOCK		mlock;
	char		*name;
	unsigned int sequence_number;
	void 		*mon_info;
} *mutex_t;

struct	condition {	/* don't reference these fields directly !*/
	LOCK	clock;
	void	*queue_first;
	void	*queue_tail;
	char	*name;
	unsigned int sequence_number;
	void 		*mon_info;
};

typedef	    struct  condition	*condition_t;

typedef	    void *any_t;
typedef	    void *cthread_t;
typedef	    void *memory_t;

/*
 * Error codes.
 *
 */

#define RESULT	int

#define T_SUCCEED		0
#define T_NOMEMORY		1
#define T_NO_THREAD_QUEUED	2
#define T_JOINING_OR_FREED	3
#define T_CANNOT_JOIN		4   /* This can be happen because the thread is
				     * FREED or DETACHED or JOINED
				     */
    
#define T_CANNOT_JOIN_MYSELF	5
#define T_ALREADY_INIT		6
#define T_TOO_BIG_MEMORY_MODULE	    7
#define T_BAD_REQUEST		    8	/* Used in cthread_configure()	*/
#define	T_SCHED_TOO_MANY_READYQS	9	/* Used in sched_util */
#define	T_SCHED_TOO_MANY_THREADS	10	/* Used in sched_util */

/*
 * Library calls
 */

extern int aprintf ARGS((char *format, ...));
extern int afprintf ARGS((void *file, char *format,...));
extern void aprintf_lock();
extern void aprintf_unlock();

/* cthread_perror() prints an error message which is the concatenation of 
 * str and an error message which corresponds to error_code. Similar to 
 * UNIX error().
 */
extern void cthread_perror ARGS((char *str, RESULT error_code));

extern void cthread_set_name ARGS((cthread_t t, char *name));

extern char *cthread_name ARGS((cthread_t   t));

extern cthread_t cthread_self();

extern any_t cthread_data ARGS((cthread_t t));

extern void cthread_set_data ARGS((cthread_t t, any_t data));

extern void *cthread_sched_info ARGS((cthread_t t));

extern void cthread_set_sched_info ARGS((cthread_t t, void *info));

/*  Cthread_init() has these parameters:
 *  int	procs;	     Number of processors   
 *  void (*func)();   Function with which the first thread will start.
*/
extern RESULT cthread_init ARGS((int procs, void (*func)()));

/*  Cthread_start() has this parameter:
 *  int	procs;	     Number of processors   
 *  Unlike cthread_init, cthread_start actually returns after starting
 *  Cthreads.
*/
extern RESULT cthread_start ARGS((int procs));

extern void mutex_set_name ARGS((mutex_t m, char *name));

extern char *mutex_name ARGS((mutex_t m));

extern void condition_set_name ARGS((condition_t c, char *name));

extern char *condition_name ARGS((condition_t c));

/*
 * In memory_alloc the parameter node specifies the logical node number from
 * the local memory bank of which the memory is going to be allocated.
 * It can be also N_CURRENT, N_ANYWHERE, with the obvious meanings.
 */

extern RESULT memory_alloc ARGS((memory_t *ptr, int size, int node));

extern RESULT memory_realloc ARGS((memory_t *ptr, int size));

extern int memory_node ARGS((memory_t ptr));

extern void memory_free ARGS((memory_t mem));

typedef struct configuration {
   int	stack_size,
	memory_exponent,
	threads_per_proc;
} *configuration_t;

#define	    DEFAULT_STACK   -1
#define	    DEFAULT_MEM	    -1
#define	    DEFAULT_THREADS -1

typedef enum {GET_CONFIG= 0, PUT_CONFIG	= 1} config_action;

extern
RESULT
cthread_configure ARGS((configuration_t conf, config_action action));

extern int
cthread_parse_args ARGS((int argc, char **argv));

extern void
get_context ARGS((cthread_t thread, cthread_context *context_ptr));

extern void
put_context ARGS((cthread_t thread, cthread_context *context_ptr));

extern
void *
get_sp_from_context ARGS((cthread_context context_ptr));

extern
void *
get_stack_bottom ARGS((cthread_t thread));

/*
 * Variables exported from the library.
 */

extern int current_processor();  /* logical processor    */
extern int number_of_processors; /* number of processors in the cluster	*/
extern int *num_of_procs;	/* number of processors in the cluster	*/

extern void cthread_alert();
extern void enable_alert();
extern void disable_alert();

extern void 
cthread_set_in_schedule_function ARGS((void (*func)()));

/* Monitoring interface */
/* these calls exist only if cthreads is build with monitoring enabled */
typedef int (*SamplingSensorProc) ARGS((int, void*));
typedef int (*FormatHandlerProc) ARGS((void*));
typedef int (*CommandHandlerProc) ARGS((void*));

extern unsigned long cthread_timestamp();
extern int cthread_sensor_switch ARGS((int s));
extern int thread_set_switch ARGS((cthread_t, int swtch));
extern int mutex_set_switch ARGS((mutex_t m, int swtch));
extern int condition_set_switch ARGS((condition_t, int swtch));
extern int thread_name_set_switch ARGS((char* name, int swtch));
extern int mutex_name_set_switch ARGS((char* name, int swtch));
extern int condition_name_set_switch ARGS((char* name, int swtch));
extern int sensor_set_switch ARGS((char* sensor, int swtch));
extern int register_sampling_sensor ARGS((unsigned long, SamplingSensorProc));
extern int register_steer_command_handler ARGS((char*, void*,
						CommandHandlerProc));

#ifdef __STDC__
#define mutex_alloc(mptr, node) app_mutex_alloc(mptr, node, #mptr)
#define condition_alloc(cptr, node) app_condition_alloc(cptr, node, #cptr)
#define cthread_fork(func, arg, node) app_cthread_fork(func, arg, node, #func)
#define cthread_publish(p) app_cthread_publish(p, #p, __FILE__, __LINE__)
#define mutex_init(mutex) app_mutex_init(mutex, #mutex, __FILE__, __LINE__)
#define condition_init(cond) app_condition_init(cond, #cond, __FILE__, __LINE__)
#else 
#define mutex_alloc(mptr, node) app_mutex_alloc(mptr, node, "mptr")
#define condition_alloc(cptr, node) app_condition_alloc(cptr, node, "cptr")
#define cthread_fork(func, arg, node) app_cthread_fork(func, arg, node, "func")
#define cthread_publish(p) app_cthread_publish(p, "p", __FILE__, __LINE__)
#define mutex_init(mutex) app_mutex_init(mutex, "mutex", __FILE__, __LINE__)
#define condition_init(cond) app_condition_init(cond, "cond", __FILE__, __LINE__)
#endif

#define mutex_lock(mptr) app_mutex_lock(mptr, __FILE__, __LINE__)
#define mutex_unlock(mptr) app_mutex_unlock(mptr, __FILE__, __LINE__)
#define mutex_clear(mptr) app_mutex_clear(mptr, __FILE__, __LINE__)
#define mutex_free(mptr) app_mutex_free(mptr, __FILE__, __LINE__)
#define condition_wait(cond, m) app_condition_wait(cond, m, __FILE__, __LINE__)
#define condition_signal(cond) app_condition_signal(cond, __FILE__, __LINE__)
#define condition_broadcast(cond) app_condition_broadcast(cond, __FILE__, __LINE__)
#define condition_clear(cond) app_condition_clear(cond, __FILE__, __LINE__)
#define condition_free(cond) app_condition_free(cond, __FILE__, __LINE__)
#define cthread_yield() app_cthread_yield(__FILE__,__LINE__)
#define cthread_exit(res) app_cthread_exit(res, __FILE__, __LINE__)
#define cthread_detach(t) app_cthread_detach(t, __FILE__, __LINE__)
#define cthread_join(t, rptr) app_cthread_join(t, rptr, __FILE__, __LINE__)
#define barrier() app_barrier(__FILE__, __LINE__)

extern RESULT app_mutex_alloc ARGS((mutex_t *mptr, int node, char *name));

extern void app_mutex_lock ARGS((mutex_t m, char *file, int line));

extern void app_mutex_unlock ARGS((mutex_t m, char *file, int line));

extern void app_mutex_clear ARGS((mutex_t m, char *file, int line));

extern void app_mutex_init ARGS((mutex_t m, char *name, char *file, int line));

extern void app_mutex_free ARGS((mutex_t m, char *file, int line));

extern RESULT app_condition_alloc ARGS((condition_t *cptr, int node, 
					char *name));

extern void app_condition_wait ARGS((condition_t c, mutex_t m, char *file,
				     int line));

extern RESULT app_condition_signal ARGS((condition_t c, char *file, int line));

extern void app_condition_broadcast ARGS((condition_t c, char *file,int line));

extern void app_condition_init ARGS((condition_t c, char *name, char *file, 
				     int line));

extern void app_condition_clear ARGS((condition_t c, char *file, int line));

extern void app_condition_free ARGS((condition_t c, char *file, int line));

extern cthread_t app_cthread_fork ARGS((any_t (*func)(), any_t arg, int node, 
					char *name));

extern cthread_t cthread_thread_alloc ARGS((any_t (*func)(), any_t arg, 
					    int node));

extern void cthread_thread_schedule ARGS((cthread_t t));

extern void app_cthread_yield ARGS((char *file, int line));

extern void app_cthread_exit ARGS((any_t res, char *file, int line));

extern RESULT app_cthread_detach ARGS((cthread_t t, char *file, int line));

extern RESULT app_cthread_join ARGS((cthread_t t, any_t *resptr, char *file,
				     int line));

extern void app_cthread_publish ARGS((void **p, char *name, char *file, int line));

extern void app_barrier ARGS((char *file, int line));

#ifdef CTHREAD_SOURCE
This file not for use within cthread source compilation!
#endif


int cth_open ARGS((const char *path, int flags, ...));
int cth_close ARGS(( int s));
int cth_socket ARGS((int domain, int type, int protocol));
int cth_dup2 ARGS((int s1, int s2));
int cth_dup ARGS((int s));
int cth_fcntl ARGS((int s, int cmd, ...));
int cth_accept ARGS((int s, void  *addr, int *addrlen));
int cth_connect ARGS((int s, void *name, int namelen));
int cth_bind ARGS((int s, void    *name, int namelen));
int cth_listen ARGS((int s, int backlog));
int cth_recv ARGS((int s, char *buf, int len, int flags));
int cth_recvfrom ARGS(( int s, char *buf, int len, int flags, 
                        void *from, int *fromlen));
int cth_readv ARGS(( int s, void *iov, int iovcnt));
int cth_send ARGS((int s, char *buf, int len, int flags));
int cth_sendto ARGS(( int s, char *buf, int len, int flags, 
                        void *to, int tolen));
int cth_writev ARGS(( int s, void *iov, int iovcnt));

#endif
