/* cf_lock.h
 */

#ifndef CF_LOCK_H
#define CF_LOCK_H

#include "hwlib.h"
#include "lock.h"
#include "simple_queue.h"

/* forward declarations */
struct cthread;

typedef struct cflocks{
        LOCK clock;
	LOCK tmp_lock;
        struct lock_queue squeue;
        int btime;
        int stime;
        int timeout;
        int priority;
        int enet_delay;
        int node_locality;
        int mutability;
        int migration;
        int replication;  /* Also used for active lock status for tmp */
        LOCK *loclock[MAX_PROC];
        void (*registration)();
        void (*acquire)();
        void (*release)();
}cflock, *cflock_t ;

typedef	struct	spin_mutex {
	LOCK		mlock;
	short		spin_no;
	string_t	name;
} *spin_mutex_t;


typedef	struct	block {
	LOCK		lock;
	LOCK            tmp_lock;
	struct cth_queue	Pqueue;
} *block_t;


void
  registration ARGS((cflock_t c));

void 
  acquire ARGS((cflock_t c));

/* The following function implements the scheduling policy */
void
  release ARGS((cflock_t c));

/*****************************************************************************/
/*                      ACTIVE LOCKS					     */
/*****************************************************************************/

void
  active_registration ARGS((cflock_t c));

void 
  active_acquire ARGS((cflock_t c));

/* The following function implements the scheduling policy */
void
  active_release ARGS((cflock_t c));

void
  manager ARGS((cflock_t c));

void  
  active_lock_exit ARGS((cflock_t c));
  
/****************************************************************************/
/* Pure blocking locks                                                      */
/****************************************************************************/


void
  block_lock ARGS((block_t m));

void
  block_unlock ARGS((block_t m));

void
  block_unlock ARGS((block_t m));

void
  block_clear ARGS((block_t m));

void
  block_init ARGS((block_t m));

RESULT
  block_alloc ARGS((block_t *mptr,
		    int node));

void
  block_free ARGS((block_t m));

/*****************************************************************************/
/*           SPIN_MUTEX LOCKS                                                */
/*****************************************************************************/

void
  spin_mutex_lock ARGS((spin_mutex_t m));

void
  spin_mutex_unlock ARGS((spin_mutex_t m));

void
  spin_mutex_clear ARGS((spin_mutex_t m));

void
  spin_mutex_init ARGS((spin_mutex_t m,
			short no_of_spin));

RESULT
  spin_mutex_alloc ARGS((spin_mutex_t *mptr,
			 int node));

void
  spin_mutex_free ARGS((spin_mutex_t m));

void
  spin_mutex_set_name ARGS((spin_mutex_t m,
			    string_t mname));

string_t
  spin_mutex_name ARGS((spin_mutex_t m));

#endif

