/*
 *
 * Modification history:
 * 
 * 1.0	 3-May-88	Initial release.
 * 1.1   Bodhi Mukherjee	Added Implementation for Sun3/50.
 * 1.2   Bodhi Mukherjee	Added Implementation for Sun3/86.
 * 1.3   Bodhi Mukherjee	Added Implementation for Sparcs.
 * 1.4   Bodhi Mukherjee	Added Implementation for Sequent.
 */

#include	"general.h"
#include	"results.h"
#include	"lock.h"
#include	"queue.h"
#include	"sync.h"
#include	"internal.h"
#include	"memalloc.h"
extern  shared	struct  local_info  *processor;
extern 		int 	            next_thread_type;

#include	"buff.h"

#define HEAD_OF_BUFF(b)		((struct buff *) (((char *) b) - sizeof(struct  buff)))
#define BUFF_OF_HEAD(h)		((buff_t) (h+1))

void
buff_init(b)
buff_t	b;
{
	LOCK_INIT(b->lock);
	b->next = 0;
	b->name = 0;
	b->count = 0;
}

void
buff_clear(b)
buff_t	b;
{
}


void
buff_free(b)
buff_t	b;
{
	struct buff	*h;
	h = HEAD_OF_BUFF(b);
	buff_clear(b);
	memory_free((memory_t) h);
}

void
  buff_set_name(b, bname)
buff_t	b;
string_t	bname;
{
	struct buff	*h;
	h = HEAD_OF_BUFF(b);
	h->name = bname;
}

string_t
buff_name(b)
buff_t	b;
{
	return(b->name);
}

RESULT
  buff_alloc(bptr, node, size)
buff_t	*bptr;
int	node;
int size;
{
	RESULT	tmp;
	char		*p;
	buff_t		b;

	if((tmp =
	    memory_alloc((memory_t *)&p, sizeof(struct buff) + size , node)) 
				!= T_SUCCEED)
		return(tmp);
	b = (buff_t) p;
	b->size = size;
	buff_init(b);
	*bptr = b;
	return(T_SUCCEED);
}
