/* $Id: adv_steer.c,v 1.3 1997/06/12 14:13:59 eisen Exp $ */

/*
 * Advanced Steering Server source.
 * 
 * This source is different from the original Falcon steering source.
 * It provides a gateway between the Progress steering lib and the cthreads/
 * Falcon system. 
 * 
 */

#include "assert.h"
#include "general.h"
#include "lock.h"
#include <stdio.h>
#include "internal.h"
#include "monitor.h"

#undef DEBUG

#if defined(DEBUG)
# define DebugCode(code_frag) {{printf("%s:%d:",__FILE__,__LINE__);}\
                            {code_frag}\
                            {puts("");\
			    fflush(stdout);}}
#else
# define DebugCode(code_frag) 
#endif

extern int adv_steer_enabled;

#if defined(ADV_STEER)
#include "steer.h"
SteeringSystem sserver = NULL;

#endif

void *
as_GetSteeringSystemHandle()
{
  assert( adv_steer_enabled );
#if defined(ADV_STEER)
  while( sserver == NULL )	/* spin on this global until it is set */
    {
      internal_cthread_yield();
    }
  return sserver;
#else
  return NULL;
#endif
}

int
as_Enable()
{
#if !defined(ADV_STEER)
  fprintf(stderr, 
	  ">>>>> Advanced steering not installed in this version.\n"
	  ">>>>> -cthread_adv_steer switch invalid.\n"
	  ">>>>> Recompile libcthreads.a\n\n");
  exit(-1);

#else
  adv_steer_enabled++;
  monitoring_enabled++;
  DebugCode(printf("cthreads - Advanced steering engaged.\n"););

#endif
  return 0;
}

int
as_Initialize()
{
#if defined(ADV_STEER)
  extern int __preCthreadsMalloc;

  assert(adv_steer_enabled);
  assert(sserver == NULL);

  DebugCode(printf("cthreads - Advanced steering initialized."););
  __preCthreadsMalloc = 1;
  sserver = (SteeringSystem)AS_Init();
  __preCthreadsMalloc = 0;
#endif

  return 0;
}

int
as_Spawn()
{
  assert(adv_steer_enabled);

#if defined(ADV_STEER)
  assert(sserver != NULL);

  DebugCode(printf("cthreads - Advanced steering spawning."););
  AS_Start(sserver);
#endif

  return 0;
}


int 
as_GetMonitorEvent(monitorID, destBuffer, maxBytes)
int monitorID;
char * destBuffer;
int maxBytes;
{
  int numBytes = maxBytes;

#if 0
  assert(monitorID >= 0 );
  assert(destBuffer != NULL);
  assert(maxBytes > 0);
  assert(lm_to_steer_bufs != NULL);

  if((numBytes = RetrieveBuffer( &lm_to_steer_bufs[monitorID],
				 destBuffer,
				 (unsigned int*) &numBytes)) 
     > 0)
    {
      DebugCode(printf("received event from lm (Size=%d)", numBytes););
    }
#endif

  return numBytes;		/* return # of bytes retrieved, 0 = nun */
}

/***** EOF *****/

