define(AC_HANDLERRETTYPE,
[AC_MSG_CHECKING([type of sv_handler field])
AC_CACHE_VAL(ac_cv_handlerrettype,
[AC_HEADER_EGREP_AND_SET([\*sv_handler], signal.h, 
changequote(,)dnl
s/[[ 	]]*\([[^ 	]]*\)[[ 	]].*/\1/, 
changequote([,])dnl
ac_cv_handlerrettype, int)])
AC_MSG_RESULT($ac_cv_type_signal)
AC_DEFINE_UNQUOTED(HANDLERRETTYPE, $ac_cv_handlerrettype)
])dnl
dnl
define(AC_JMPBUFUNITTYPE,
[AC_MSG_CHECKING([type of elements in jmpbuf array])
AC_CACHE_VAL(ac_cv_jmpbufunittype,
ac_cv_jmpbufunittype=void
[AC_EGREP_HEADER(
changequote(,)dnl
typedef[ 	]+long[ 	]+jmp_buf,setjmp.h,
changequote([,])dnl
ac_cv_jmpbufunittype=long,
[AC_EGREP_HEADER(typedef[[ 	]]+int[[ 	]]+jmp_buf,setjmp.h,
ac_cv_jmpbufunittype=int,
[AC_EGREP_HEADER(typedef[[ 	]]+__uint64_t[[ 	]]+jmp_buf,setjmp.h,
ac_cv_jmpbufunittype=__uint64_t,
[])])])
])
AC_MSG_RESULT($ac_cv_jmpbufunittype)
if test $ac_cv_jmpbufunittype != void; then
AC_DEFINE_UNQUOTED(JMPBUFUNITTYPE, $ac_cv_jmpbufunittype)
fi
]
)dnl
AC_DEFUN(AC_TRY_CONTEXT_VALUE,[
AC_TRY_RUN([#if defined(__svr4__) || defined(__SVR4)
#include <ucontext.h>
#include <stdio.h>
#include <stdlib.h>
void
fix_jbuf(jbuf, func, val)
ucontext_t *jbuf;
int (*func)();
int val;
{
    char *stackbase = (char*)malloc(102400);
    void *usable_stack_base = stackbase + 4096 +
      10240 - 1;
    getcontext(jbuf);
    jbuf->uc_stack.ss_sp = (char*)((long)usable_stack_base & ~0xf);
    jbuf->uc_stack.ss_sp = (char*)jbuf->uc_stack.ss_sp - val;
    jbuf->uc_stack.ss_size = 10240;
    jbuf->uc_stack.ss_flags = 0;
    makecontext(jbuf, (void(*)()) func, 3, val, 0);
}

func(val)
int val;
{
    fprintf(stderr, " %d works", val);
    exit(0);
}

void
main(argc, argv)
int argc;
char **argv;
{
    int val= $1;
    ucontext_t jbuf;
    fix_jbuf(&jbuf, func, val);
    setcontext(&jbuf);
}
#else
main()
{
    exit(0);
}
#endif
],$2,$3,)])
dnl
dnl
AC_DEFUN(AC_CONTEXT_FUDGE_VALUE,
[dnl This message is consistent in form with the other checking messages,
dnl and with the result message.
AC_MSG_CHECKING([makecontext fudge value])
AC_CACHE_VAL(ac_cv_context_fudge_value,
[AC_TRY_CONTEXT_VALUE(4, ac_cv_context_fudge_value=4,
			 AC_TRY_CONTEXT_VALUE(8, ac_cv_context_fudge_value=8,
			 AC_TRY_CONTEXT_VALUE(0, ac_cv_context_fudge_value=0)))])
AC_MSG_RESULT($ac_cv_context_fudge_value)
AC_DEFINE_UNQUOTED(CONTEXT_FUDGE_VALUE,$ac_cv_context_fudge_value)
])
dnl
AC_DEFUN(AC_C_VOLATILE,
[dnl This message is consistent in form with the other checking messages,
dnl and with the result message.
AC_MSG_CHECKING([for working volatile])
AC_CACHE_VAL(ac_cv_c_volatile,
[AC_TRY_COMPILE(, [typedef volatile int;],
ac_cv_c_volatile=yes, ac_cv_c_volatile=no)])dnl
AC_MSG_RESULT($ac_cv_c_volatile)
if test $ac_cv_c_volatile = no; then
  AC_DEFINE(volatile, ,[Define "volatile" as null if the compiler doesn't support the keyword])
fi
])
define(AC_HEADER_EGREP_AND_SET,
[AC_REQUIRE_CPP()AC_PROVIDE([$0])echo '#include "confdefs.h"
#include <$2>' > conftest.${ac_ext}
eval "$ac_cpp conftest.${ac_ext} > conftest.out 2>&1"
var=`egrep "$1" conftest.out|sed "$3"`
if test -z "$var"; then
var=$5
fi
$4=$var
rm -rf conftest*
])dnl
dnl
