
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>

#include "../config.h"
#ifdef USE_CTHREADS
#include "cthread.h"
#endif
#include "otl.h"
#include "gen_thread.h"
#include "example2.h"

#ifdef _WIN32
#include <windows.h>
#define sleep(x) Sleep(1000)
#define srand48(x) srand(x)
#define lrand48() rand()
#define drand48() (((double) rand())/ (double) RAND_MAX)
#else
extern int sleep();
#endif

object_ref
init_func()
{
    return COBS_a_object_create();
}

void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for a simple server.  We'll follow through the flow.
     */
    object_ref init_obj;

    /* initialize some kind of threading system.... */
#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, cthread_parse_args is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
    gen_cthread_init();
    cthread_start(1);
#elif NON_THREADED
    gen_null_init();
#else
    gen_pthread_init();
#endif
    /*  
     *  Init_func only gets called in the process that
     *  creates the group.  But in *every* process the return value of
     *  init_cobs() is the reference that was created in that one call to
     *  init_func...  Since we want to be the server that other clients talk 
     *  to, our init_func returns an object reference.  Clients will get 
     *  that object reference when they call init_cobs().
     *  The first parameter to init_cobs() is a string "application name".
     *  Other programs calling init_cobs() with the same string will be 
     *  matched to this one as part of the same group.  
     *  See dataexchange/doc/group_services.3 for more info on how programs
     *  groups are matched with existing groups.
     */
    init_obj = init_cobs("example", init_func);

    /* 
     * I'm supposed to be the server, so lets just hang out forever 
     * letting people use the object we created in init_func().
     */
    while (1) {
#ifdef NON_THREADED
	cobs_blocking_poll();
#else
	/*
	 * if there's a kernel-level thread handling network stuff, then
	 * we could sleep forever. If user-level, we should yield constantly
	 * to let it run.  This is a compromise.  It accomplishes a poll 
	 * of the network every second.  Better optimization requires 
	 * knowledge of the underlying thread system.
	 */
	sleep(1);
	thr_thread_yield();
#endif
    }
}
