/*
 *  See ../example1/example_client.c for more general comments 
 */

#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#ifndef _WIN32
#include <unistd.h>
#endif

#include "../config.h"
#ifdef USE_CTHREADS
#include "cthread.h"
#endif
#include "otl.h"
#include "gen_thread.h"
#ifdef _WIN32
#include <windows.h>
#define sleep(x) Sleep(1000)
#define srand48(x) srand(x)
#define lrand48() rand()
#define drand48() (((double) rand())/ (double) RAND_MAX)
#else
extern unsigned sleep(unsigned);
#endif
#include "example2_COBS_.h"

object_ref
init_func()
{
    printf("start the server first, we shouldn't have the initial object\n");
    exit(1);
}

void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    int i;
    CORBA_Object init_obj;
    CORBA_Environment *ev;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
    gen_cthread_init();
    cthread_start(1);
#elif NON_THREADED
    gen_null_init();
#else
    gen_pthread_init();
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     */
    init_obj = init_cobs("example", init_func);
    COBS_create_Environment_object(&ev);

    /* seed the random numbers */
    srand48(getpid());

    /* I'm supposed to be the client, so invoke a few times */
    for (i = 0; i< 5; i++) {
	CORBA_long a = lrand48() % 20;
	CORBA_sequence_float_4 b;
	CORBA_sequence_float_4 *total;
	CORBA_sequence_float_4_Init(&b, 4, NULL);
	b._buffer[0] = drand48();
	b._buffer[1] = drand48();
	b._buffer[2] = drand48();
	b._buffer[3] = drand48();
	printf("before A is %ld\n", a);
	a_SetA(init_obj, &a, ev);
	printf("after A is %ld\n", a);
	a--;
	sleep(1);
	a_SetB(init_obj, &b, ev);
	sleep(1);
	total = a_GetTotal(init_obj, ev);
	printf(" A = %ld, B = (%g, %g, %g, %g), A*B = (%g, %g, %g, %g)\n", 
	       a, b._buffer[0], b._buffer[1], b._buffer[2], b._buffer[3],
	       total->_buffer[0], total->_buffer[1], total->_buffer[2],
	       total->_buffer[3]);
	if ((a*b._buffer[0] != total->_buffer[0]) || 
	    (a*b._buffer[1] != total->_buffer[1])) {
	    printf("	Real answer is (%g, %g, %g, %g), someone else interfered\n", 
		   a*b._buffer[0], a*b._buffer[1], a*b._buffer[2],
		   a*b._buffer[3]);
	}
#ifdef USE_CTHREADS
	thr_thread_yield();
#endif
    }
}
