
#include <malloc.h>
#include <stdlib.h>
#include <stdio.h>
#ifndef _WIN32
#include <unistd.h>
#endif

#include "../config.h"
#ifdef USE_CTHREADS
#include "cthread.h"
#endif
#include "otl.h"
#include "gen_thread.h"
#ifdef _WIN32
#include <windows.h>
#define sleep(x) Sleep(1000)
#define srand48(x) srand(x)
#define lrand48() rand()
#define drand48() (((double) rand())/ (double) RAND_MAX)
#else
extern unsigned sleep(unsigned);
#endif
#include "example1.h"

object_ref
init_func()
{
    printf("start the server first, we shouldn't have the initial object\n");
    exit(1);
}

void
main(argc, argv)
int argc;
char **argv;
{
    /*  
     * the main function for cobs_test.  We'll follow through the flow.
     */
    int i;
    CORBA_Object init_obj;
    CORBA_Environment *ev;

#ifdef USE_CTHREADS
    /*  
     * if we're using Cthreads, this is a good idea.
     */
    argc = cthread_parse_args(argc, argv);
    gen_cthread_init();
    cthread_start(1);
#elif NON_THREADED
    gen_null_init();
#else
    gen_pthread_init();
#endif
    /*  
     *  init_func only gets called in the process that creates the group
     *  That shouldn't be us.  But in *every* process the return value of 
     *  init_cobs() is the reference that was created in that one call to
     *  init_func, presumably in the server.
     *  The first parameter to init_cobs() is a string "application name".
     *  Other programs calling init_cobs() with the same string will be 
     *  matched to this one as part of the same group.  
     *  See dataexchange/doc/group_services.3 for more info on how programs
     *  groups are matched with existing groups.
     */
    init_obj = init_cobs("example", init_func);
    COBS_create_Environment_object(&ev);

    /* seed the random numbers */
    srand48(getpid());

    /* I'm supposed to be the client, so invoke a few times */
    for (i = 0; i< 5; i++) {
	CORBA_long a = lrand48() % 20;
	a_complex b;
	a_complex total;
	printf("before A is %ld\n", a);
	a_SetA(init_obj, &a, ev);
	printf("after A is %ld\n", a);
	a--;
	sleep(1);
	b.r = drand48();
	b.i = drand48();
	a_SetB(init_obj, &b, ev);
	sleep(1);
	total = a_GetTotal(init_obj, ev);
	printf(" A = %ld, B = (%g, %g), A*B = (%g, %g)\n", a, b.r, b.i, 
	       total.r, total.i);
	if ((a*b.i != total.i) || (a*b.r != total.r)) {
	    /* this could happen if another client is running concurrently */
	    printf("	Real answer is (%g, %g), someone else interfered\n", 
		   a*b.r, a*b.i);
	}
#ifdef USE_CTHREADS
	thr_thread_yield();
#endif
    }
}
