#include "otl.h"
#include "CosNaming.h"
#include "stdlib.h"
#include "malloc.h"
#include "string.h"

struct name_space;

typedef struct name_element {
    char *name;
    char *kind;
    void *item;
    int is_subspace;
} *NameElement;

typedef struct name_space {
    int name_count;
    NameElement list;
} *NameSpace;

NameSpace
new_name_space()
{
    NameSpace ns = malloc(sizeof(struct name_space));
    ns->name_count = 0;
    ns->list = malloc(sizeof(struct name_element));
    return ns;
}

void
enlarge_name_space(ns)
NameSpace ns;
{
    ns->list = realloc(ns->list, 
		       sizeof(struct name_element) * (ns->name_count + 1));
}

void
delete_entry_name_space(ns, entry)
NameSpace ns;
int entry;
{
    int i;
    for (i=entry; i < ns->name_count-1; i++) {
	ns->list[i] = ns->list[i+1];
    }
    ns->name_count--;
}

NameElement
ns_resolve(ns, name_str, list_element)
NameSpace ns;
char *name_str;
{
    int i;
    for (i=0; i< ns->name_count; i++) {
	if (ns->list[i].name != NULL) {
	    if (name_str != NULL) {
		if (strcmp(ns->list[i].name, name_str) ==0){
		    /* found element */
		    return (&ns->list[i]);
		}
	    }
	}
    }
    return NULL;
}
		

static CORBA_void   
internal_bind(object, n, item, ev, rebind, context)
CosNaming_NamingContext object;
CosNaming_Name  *n;
void *item;
CORBA_Environment *ev;
int rebind;
int context;
{
    NameSpace root;
    NameElement element;
    if (ev->instanceData == NULL) {
	ev->instanceData = new_name_space();
    }
    root = ev->instanceData;
    
    if (strlen(n->_buffer[0].id) == 0) {
	printf("**** Raise Invalid Name\n");
	return;
    }
    element = ns_resolve(root, n->_buffer[0].id);
    if (element == NULL) {
	if (n->_length != 1) {
	    printf("**** Raise Not Found\n");
	    return;
	} else {
	    enlarge_name_space(root);
	    if (n->_buffer[0].id != NULL) {
		root->list[root->name_count].name = strdup(n->_buffer[0].id);
	    } else {
		root->list[root->name_count].name = NULL;
	    }
	    if (n->_buffer[0].kind != NULL) {
		root->list[root->name_count].kind =strdup(n->_buffer[0].kind);
	    } else {
		root->list[root->name_count].kind = NULL;
	    }
	    root->list[root->name_count].is_subspace = context;
	    root->list[root->name_count].item = item;
	    root->name_count++;
	}
    } else {
	/* found something at this level */
	if (n->_length != 1) {
	    if (element->is_subspace) {
		CosNaming_Name n2;
		CosNaming_NamingContext nc = 
		    (CosNaming_NamingContext) element->item;
		n2._length = n->_length -1;
		n2._maximum = n->_length -1;
		n2._buffer = &(n->_buffer[1]);
		/* recurse */
		if (context) {
		    if (rebind) {
			CosNaming_NamingContext_rebind_context(nc, &n2, item,
							       ev);
		    } else {
			CosNaming_NamingContext_bind_context(nc, &n2, item, 
							     ev);
		    }
		} else {
		    if (rebind) {
			CosNaming_NamingContext_rebind(nc, &n2, item, ev);
		    } else {
			CosNaming_NamingContext_bind(nc, &n2, item, ev);
		    }
		}
	    } else {
		printf("**** Raise Not Found\n");
	    }
	} else {
	    /* ending at this level */
	    if (rebind) {
		free(element->name);
		if (!element->is_subspace) {
		    otl_free_obj_ref((CORBA_Object)element->item);
		}
		if (n->_buffer[n->_length-1].id != NULL) {
		    element->name = strdup(n->_buffer[n->_length-1].id);
		} else {
		    element->name = NULL;
		}
		if (n->_buffer[n->_length-1].kind != NULL) {
		    element->kind = strdup(n->_buffer[n->_length-1].kind);
		} else {
		    element->kind = NULL;
		}
		element->is_subspace = context;
		element->item = item;
	    } else {
#define RAISE(env,exception) { (env)->returnCode=(exception);\
	(env)->_major=CORBA_USER_EXCEPTION; }
		printf("**** Raise AlreadyBound\n");
	    }
	}
    }
}

extern CORBA_void   
impl_CosNaming_NamingContext_bind(object, n, obj, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CORBA_Object  obj;
CORBA_Environment *ev;
{
    internal_bind(object, n, (void*)copy_object_ref(obj), ev, 0, 0);
}

extern CORBA_void   
impl_CosNaming_NamingContext_rebind(object, n, obj, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CORBA_Object  obj;
CORBA_Environment *ev;
{
    internal_bind(object, n, (void*)copy_object_ref(obj), ev, 1, 0);
}

extern CORBA_void   
impl_CosNaming_NamingContext_bind_context(object, n, nc, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CosNaming_NamingContext nc;
CORBA_Environment *ev;
{
    internal_bind(object, n, (void*)nc, ev, 0, 1);
}

extern CORBA_void   
impl_CosNaming_NamingContext_rebind_context(object, n, nc, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CosNaming_NamingContext nc;
CORBA_Environment *ev;
{
    internal_bind(object, n, (void*)nc, ev, 1, 1);
}

extern CORBA_Object   
impl_CosNaming_NamingContext_resolve(object, n, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CORBA_Environment *ev;
{
    NameSpace root;
    NameElement element;
    if (ev->instanceData == NULL) {
	ev->instanceData = new_name_space();
    }
    root = ev->instanceData;
    
    if (strlen(n->_buffer[0].id) == 0) {
	printf("**** Raise Invalid Name\n");
    }
    element = ns_resolve(root, n->_buffer[0].id);
    if (element == NULL) {
	printf("**** Raise Not Found\n");
	return NULL;
    } else {
	/* found something at this level */
	if (n->_length != 1) {
	    if (element->is_subspace) {
		CosNaming_Name n2;
		CosNaming_NamingContext nc = 
		    (CosNaming_NamingContext) element->item;
		n2._length = n->_length -1;
		n2._maximum = n->_length -1;
		n2._buffer = &(n->_buffer[1]);
		/* recurse */
		return CosNaming_NamingContext_resolve(nc, &n2, ev);
	    } else {
		printf("**** Raise Not Found\n");
		return NULL;
	    }
	} else {
	    return element->item;
	}
    }
}

extern CORBA_Object   
impl_CosNaming_NamingContext_unbind(object, n, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CORBA_Environment *ev;
{
    NameSpace root;
    NameElement element;
    if (ev->instanceData == NULL) {
	ev->instanceData = new_name_space();
    }
    root = ev->instanceData;
    
    if (strlen(n->_buffer[0].id) == 0) {
	printf("**** Raise Invalid Name\n");
    }
    element = ns_resolve(root, n->_buffer[0].id);
    if (element == NULL) {
	printf("**** Raise Not Found\n");
	return NULL;
    } else {
	/* found something at this level */
	if (n->_length != 1) {
	    if (element->is_subspace) {
		CosNaming_Name n2;
		CosNaming_NamingContext nc = 
		    (CosNaming_NamingContext) element->item;
		n2._length = n->_length -1;
		n2._maximum = n->_length -1;
		n2._buffer = &(n->_buffer[1]);
		/* recurse */
		return CosNaming_NamingContext_unbind(nc, &n2, ev);
	    } else {
		printf("**** Raise Not Found\n");
		return NULL;
	    }
	} else {
	    return element->item;
	}
    }
}

extern CosNaming_NamingContext  
impl_CosNaming_NamingContext_new_context(object, ev)
CosNaming_NamingContext object;
CORBA_Environment *ev;
{
    CosNaming_NamingContext context;
    context = CosNaming_NamingContext__Create(NULL);
    return context;
}

extern CosNaming_NamingContext  
impl_CosNaming_NamingContext_bind_new_context(object, n, ev)
CosNaming_NamingContext object;
CosNaming_Name  *n;
CORBA_Environment *ev;
{
    CosNaming_NamingContext context = 
	CosNaming_NamingContext_new_context(object, ev);
    CosNaming_NamingContext_bind_context(object, n, context, ev);
    return context;
}

extern CORBA_void   
impl_CosNaming_NamingContext_destroy(object, ev)
CosNaming_NamingContext object;
CORBA_Environment *ev;
{
}

struct iterator_data {
    int point;
    NameSpace ns;
};
    
extern CORBA_void   
impl_CosNaming_NamingContext_list(object, how_many, bl, bi, ev)
CosNaming_NamingContext object;
CORBA_unsigned_long  how_many;
CosNaming_BindingList  *bl;
CosNaming_BindingIterator  *bi;
CORBA_Environment *ev;
{
    NameSpace ns = ev->instanceData;
    if ((how_many != 0) && (ns->name_count != 0)) {
	int i;
	int count = how_many;
	if (how_many > ns->name_count) {
	    count = ns->name_count;
	}
	bl->_length = count;
	bl->_maximum = count;
	bl->_buffer = malloc(sizeof(CosNaming_Binding) * count);
	for (i=0; i<count; i++) {
	    bl->_buffer[i].binding_name._length = 1;
	    bl->_buffer[i].binding_name._maximum = 1;
	    bl->_buffer[i].binding_name._buffer = 
		malloc(sizeof(CosNaming_NameComponent_s));
	    bl->_buffer[i].binding_name._buffer[0].id = ns->list[i].name;
	    bl->_buffer[i].binding_name._buffer[0].kind = ns->list[i].kind;
	}
    } else {
	/* either no names, or zero length sequence requested */
	bl->_length = 0;
	bl->_maximum = 0;
	bl->_buffer = NULL;
    }
    if (how_many < ns->name_count) {
    	struct iterator_data *idata = malloc(sizeof(struct iterator_data));

	idata->point = how_many;
	idata->ns = ev->instanceData;
	*bi = CosNaming_BindingIterator__Create(idata);
    } else {
	/* everything in sequence */
	*bi = NULL;
    }
}

extern CORBA_boolean   
impl_CosNaming_BindingIterator_next_one(object, b, ev)
CosNaming_BindingIterator object;
CosNaming_Binding  *b;
CORBA_Environment *ev;
{
    struct iterator_data *idata = ev->instanceData;
    if (idata->point >= idata->ns->name_count) {
	b->binding_name._length = 0;
	b->binding_name._buffer = NULL;
	return 0;
    } else {
	b->binding_name._length = 1;
	b->binding_name._buffer = malloc(sizeof(b->binding_name._buffer[0]));
	b->binding_name._buffer[0].id = idata->ns->list[idata->point].name;
	b->binding_name._buffer[0].kind = idata->ns->list[idata->point].kind;
	b->binding_type = idata->ns->list[idata->point].is_subspace ? 
	    ncontext : nobject;
	idata->point++;
	return 1;
    }
}

extern CORBA_boolean   
impl_CosNaming_BindingIterator_next_n(object, how_many, bl, ev)
CosNaming_BindingIterator object;
CORBA_unsigned_long  how_many;
CosNaming_BindingList  *bl;
CORBA_Environment *ev;
{
    struct iterator_data *idata = ev->instanceData;
    NameSpace ns = idata->ns;
    if ((how_many != 0) && ((ns->name_count - idata->point) != 0)) {
	int i;
	int count = how_many;
	if (how_many > (ns->name_count - idata->point)) {
	    count = ns->name_count - idata->point;
	}
	bl->_length = count;
	bl->_maximum = count;
	bl->_buffer = malloc(sizeof(CosNaming_Binding) * count);
	for (i=0; i<count; i++) {
	    bl->_buffer[0].binding_name._length = 1;
	    bl->_buffer[0].binding_name._maximum = 1;
	    bl->_buffer[0].binding_name._buffer = 
		malloc(sizeof(CosNaming_NameComponent_s));
	    bl->_buffer[0].binding_name._buffer[0].id = ns->list[i].name;
	    bl->_buffer[0].binding_name._buffer[0].kind = ns->list[i].kind;
	}
	idata->point += count;
	return 1;
    } else {
	/* either no names, or zero length sequence requested */
	bl->_length = 0;
	bl->_maximum = 0;
	bl->_buffer = NULL;
	return 0;
    }
}

extern CORBA_void   
impl_CosNaming_BindingIterator_destroy(object, ev)
CosNaming_BindingIterator object;
CORBA_Environment *ev;
{
    free(ev->instanceData);
    /* should free object */
}
