
#include "stdlib.h"
#include "stdio.h"
#include <io.h>
#include <DE.h>
#include <otl.h>
#include <assert.h>
#include "CosEventChannelAdmin.h"

extern DExchange otl_private_de;

void 
impl_CosEventChannelAdmin_ProxyPushConsumer_disconnect_push_consumer(CosEventChannelAdmin_ProxyPushConsumer o, CORBA_Environment *ev)
{
    printf("In pushconsumer_disconnect_push_consumer\n");
}

void 
impl_CosEventChannelAdmin_ProxyPushSupplier_disconnect_push_supplier(CosEventChannelAdmin_ProxyPushSupplier o, CORBA_Environment *ev)
{
    printf("In proxypushsupplier_disconnect_push_supplier\n");
}

void 
impl_CosEventChannelAdmin_ProxyPushConsumer_push(CosEventChannelAdmin_ProxyPushConsumer o, CORBA_any data, CORBA_Environment *ev)
{
    static atom_t cobs_ec_handle_atom = 0;
    ECSourceHandle handle;
    if (cobs_ec_handle_atom == 0) {
   	cobs_ec_handle_atom = attr_atom_from_string("EC:CHANNEL_HANDLE");
    }
    query_attr(o->obj_name, cobs_ec_handle_atom, NULL, (void**)&handle);
    ECsubmit_event(handle, data._value, data._length);
}

static void
push_function(event, length, client_data)
void *event;
int length;
void *client_data;
{
    CosEventComm_PushConsumer consumer = 
	(CosEventComm_PushConsumer) client_data;
    static atom_t no_return_atom = 0;
    CORBA_any a;
    CORBA_Environment ev;

    if (no_return_atom == 0) {
	no_return_atom = attr_atom_from_string("OTL:NO_RETURN");
    }
    set_attr(consumer->obj_name, no_return_atom, Attr_Int4, (attr_value)1);
    a._length = length;
    a._value = (void*) malloc(length);
    memcpy(a._value, event, length);
    COBS_init_Environment_object(&ev);
    CosEventComm_PushConsumer_push(consumer, a, &ev);
}

void 
impl_CosEventChannelAdmin_ProxyPushSupplier_connect_push_consumer(CosEventChannelAdmin_ProxyPushSupplier o, CosEventComm_PushConsumer push_consumer, CORBA_Environment *ev)
{
    static atom_t cobs_ec_id_atom = 0, cobs_ec_handle_atom = 0;
    EChannel chan;
    char *chan_id;
    CosEventComm_PushConsumer stored_consumer_ref;
    ECSinkHandle handle;
    if (cobs_ec_id_atom == 0) {
   	cobs_ec_id_atom = attr_atom_from_string("EC:CHANNEL_ID");
   	cobs_ec_handle_atom = attr_atom_from_string("EC:CHANNEL_HANDLE");
    }
    query_attr(o->obj_name, cobs_ec_id_atom, NULL, (void**)&chan_id);
    chan = EChannel_open(otl_private_de, chan_id);
    assert(chan);
    stored_consumer_ref = copy_object_ref(push_consumer);
    handle = ECsink_subscribe(chan, push_function, stored_consumer_ref);
    assert(handle);
}

CosEventChannelAdmin_ProxyPushSupplier 
impl_CosEventChannelAdmin_ConsumerAdmin_obtain_push_supplier(CosEventChannelAdmin_ConsumerAdmin o, CORBA_Environment *ev)
{
    static atom_t cobs_ec_id_atom = 0;
    CosEventChannelAdmin_ProxyPushSupplier supplier;
    char *chan_id;
    if (cobs_ec_id_atom == 0) {
   	cobs_ec_id_atom = attr_atom_from_string("EC:CHANNEL_ID");
    }
    query_attr(o->obj_name, cobs_ec_id_atom, NULL, (void**)&chan_id);
    supplier = COBS_CosEventChannelAdmin_ProxyPushSupplier_object_create();
    add_attr(supplier->obj_name, cobs_ec_id_atom, Attr_String, 
	     (attr_value) chan_id);
    return supplier;
}

CosEventChannelAdmin_ProxyPushConsumer 
impl_CosEventChannelAdmin_SupplierAdmin_obtain_push_consumer(CosEventChannelAdmin_SupplierAdmin o, CORBA_Environment *ev)
{
    static atom_t cobs_ec_id_atom = 0, cobs_ec_handle_atom = 0;
    CosEventChannelAdmin_ProxyPushConsumer consumer;
    EChannel chan;
    char *chan_id;
    ECSourceHandle handle;
    if (cobs_ec_id_atom == 0) {
   	cobs_ec_id_atom = attr_atom_from_string("EC:CHANNEL_ID");
   	cobs_ec_handle_atom = attr_atom_from_string("EC:CHANNEL_HANDLE");
    }
    query_attr(o->obj_name, cobs_ec_id_atom, NULL, (void**)&chan_id);
    chan = EChannel_open(otl_private_de, chan_id);
    assert(chan);
    consumer = COBS_CosEventChannelAdmin_ProxyPushConsumer_object_create();
    handle = ECsource_subscribe(chan);
    assert(handle);
    add_attr(consumer->obj_name, cobs_ec_handle_atom, Attr_Int4, 
	     (attr_value) handle);
    return consumer;
}

extern void 
impl_CosEventChannelAdmin_EventChannel_initialize(CosEventChannelAdmin_EventChannel object, CORBA_Environment *ev)
{
    static atom_t cobs_ec_atom = 0, cobs_ec_id_atom = 0;
    EChannel chan = EChannel_create(otl_private_de);
    char *chan_id = ECglobal_id(chan);
    printf("created channel %s\n", chan_id);
    if (cobs_ec_atom == 0) {
   	cobs_ec_id_atom = attr_atom_from_string("EC:CHANNEL_ID");
   	cobs_ec_atom = attr_atom_from_string("EC:CHANNEL");
    }
   add_attr(object->obj_name, cobs_ec_id_atom, Attr_String, (attr_value) chan_id);
   add_attr(object->obj_name, cobs_ec_atom, Attr_Int4, (attr_value) chan);
}    

extern void 
impl_CosEventChannelAdmin_EventChannel_destroy(CosEventChannelAdmin_EventChannel o, CORBA_Environment *ev)
{
    static atom_t cobs_ec_atom = 0;
    EChannel chan;
    if (cobs_ec_atom == 0) {
   	cobs_ec_atom = attr_atom_from_string("EC:CHANNEL");
    }
   query_attr(o->obj_name, cobs_ec_atom, NULL, (void**)&chan);
}

extern CosEventChannelAdmin_SupplierAdmin 
impl_CosEventChannelAdmin_EventChannel_for_suppliers(CosEventChannelAdmin_EventChannel o, CORBA_Environment *ev)
{
    static atom_t cobs_ec_id_atom = 0;
    static atom_t is_local_atom = 0;
    CosEventChannelAdmin_SupplierAdmin supplier;
    char *chan_id;
    if (cobs_ec_id_atom == 0) {
   	cobs_ec_id_atom = attr_atom_from_string("EC:CHANNEL_ID");
	is_local_atom = attr_atom_from_string("OTL:IS_LOCAL");
    }
    query_attr(o->obj_name, cobs_ec_id_atom, NULL, (void**)&chan_id);
    supplier = COBS_CosEventChannelAdmin_SupplierAdmin_object_create();
    add_attr(supplier->obj_name, cobs_ec_id_atom, Attr_String, 
	     (attr_value) chan_id);
    add_attr(supplier->obj_name, is_local_atom, Attr_Int4, 
	     (attr_value) 1);
    return supplier;
}

extern CosEventChannelAdmin_ConsumerAdmin impl_CosEventChannelAdmin_EventChannel_for_consumers(CosEventChannelAdmin_EventChannel o, CORBA_Environment *ev)
{
    static atom_t cobs_ec_id_atom = 0;
    static atom_t is_local_atom = 0;
    CosEventChannelAdmin_ConsumerAdmin consumer;
    char *chan_id;
    if (cobs_ec_id_atom == 0) {
   	cobs_ec_id_atom = attr_atom_from_string("EC:CHANNEL_ID");
	is_local_atom = attr_atom_from_string("OTL:IS_LOCAL");
    }
    query_attr(o->obj_name, cobs_ec_id_atom, NULL, (void**)&chan_id);
    consumer = COBS_CosEventChannelAdmin_ConsumerAdmin_object_create();
    add_attr(consumer->obj_name, cobs_ec_id_atom, Attr_String, 
	     (attr_value) chan_id);
    add_attr(consumer->obj_name, is_local_atom, Attr_Int4, 
	     (attr_value) 1);
    return consumer;
}

