%{

int		lex_offset = 1, line_count = 1;

#ifndef YY_PROTO
#define YY_PROTO(x) ()
#endif

extern int
yywrap YY_PROTO(( void ))
{
    return 1;
}

%}
%%

"/*""/"*(([^*/][^*]*)?"*"+)*"/"	{lex_offset += yyleng;}

Interface		{lex_offset += yyleng; return(INTERFACE);}
Attribute   		{lex_offset += yyleng; return(ATTRIBUTE);}
TypeCode      		{lex_offset += yyleng; return(TYPECODE);}
TypeName		{lex_offset += yyleng; return(TYPENAME);}
BaseTypeCode		{lex_offset += yyleng; return(BASETYPECODE);}
BASETYPECODE		{lex_offset += yyleng; return(BASETYPECODE);}
BaseTypeName		{lex_offset += yyleng; return(BASETYPENAME);}
NT_enum                 {lex_offset += yyleng; return(NT_ENUM);}
NT_pre_defined          {lex_offset += yyleng; return(NT_PRE_DEFINED);}
NT_struct               {lex_offset += yyleng; return(NT_STRUCT);}
NT_string               {lex_offset += yyleng; return(NT_STRING);}
NT_sequence             {lex_offset += yyleng; return(NT_SEQUENCE);}
NT_array                {lex_offset += yyleng; return(NT_ARRAY);}
NT_interface            {lex_offset += yyleng; return(NT_INTERFACE);}
MAXLEN 			{lex_offset += yyleng; return(MAXLEN);}
NDIMS 			{lex_offset += yyleng; return(NDIMS);}
Readonly                {lex_offset += yyleng; return(READONLY);}
MIRROR                  {lex_offset += yyleng; return(MIRROR);}
Operation		{lex_offset += yyleng; return(OPERATION);}
Argument		{lex_offset += yyleng; return(ARGUMENT);}
IN     			{lex_offset += yyleng; return(IN);}
OUT    			{lex_offset += yyleng; return(OUT);}
INOUT  			{lex_offset += yyleng; return(INOUT);}
Context                 {lex_offset += yyleng; return(CONTEXT);}
TYPEINFO                {lex_offset += yyleng; return(TYPEINFO);}
TYPEDEF_OF              {lex_offset += yyleng; return(TYPEDEF_OF);}
NB_FIELDS               {lex_offset += yyleng; return(NB_FIELDS);}
FIELDTYPE               {lex_offset += yyleng; return(FIELDTYPE);}
FIELDNAME               {lex_offset += yyleng; return(FIELDNAME);}

[A-Za-z][A-Za-z0-9_]*	{
			   lex_offset += yyleng; return(ID);
			}
[0-9][0-9]*		{
			   lex_offset += yyleng; return(DIGITS);
			}

[ \t]			{lex_offset += yyleng;}
[ \n]			{lex_offset = 1; line_count++;}
%%


